/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.TsigKey;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTsigKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTsigKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateTsigKeyRequest interceptRequest(UpdateTsigKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateTsigKeyRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTsigKeyId(), (String)"tsigKeyId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateTsigKeyDetails(), (String)"updateTsigKeyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("tsigKeys").path(HttpUtils.encodePathSegment((String)request.getTsigKeyId()));
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("If-Match", (Object)request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", (Object)request.getIfUnmodifiedSince());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateTsigKeyResponse> fromResponse() {
        Function<Response, UpdateTsigKeyResponse> transformer = new Function<Response, UpdateTsigKeyResponse>(){

            public UpdateTsigKeyResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.UpdateTsigKeyResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TsigKey.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateTsigKeyResponse.Builder builder = UpdateTsigKeyResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.tsigKey((TsigKey)response.getItem());
                Optional eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag");
                if (eTagHeader.isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateTsigKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

