/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.dns.requests.UpdateResolverEndpointRequest;
import com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateResolverEndpointConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateResolverEndpointConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateResolverEndpointRequest interceptRequest(UpdateResolverEndpointRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateResolverEndpointRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getResolverEndpointName(), (String)"resolverEndpointName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateResolverEndpointDetails(), (String)"updateResolverEndpointDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("resolvers").path(HttpUtils.encodePathSegment((String)request.getResolverId())).path("endpoints").path(HttpUtils.encodePathSegment((String)request.getResolverEndpointName()));
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("If-Match", (Object)request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", (Object)request.getIfUnmodifiedSince());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateResolverEndpointResponse> fromResponse() {
        Function<Response, UpdateResolverEndpointResponse> transformer = new Function<Response, UpdateResolverEndpointResponse>(){

            public UpdateResolverEndpointResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ResolverEndpoint.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateResolverEndpointResponse.Builder builder = UpdateResolverEndpointResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.resolverEndpoint((ResolverEndpoint)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateResolverEndpointResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

