/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.View;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetViewConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetViewConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetViewRequest interceptRequest(GetViewRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetViewRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getViewId(), (String)"viewId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("views").path(HttpUtils.encodePathSegment((String)request.getViewId()));
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfModifiedSince() != null) {
            ib.header("If-Modified-Since", (Object)request.getIfModifiedSince());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("If-None-Match", (Object)request.getIfNoneMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetViewResponse> fromResponse() {
        Function<Response, GetViewResponse> transformer = new Function<Response, GetViewResponse>(){

            public GetViewResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.GetViewResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(View.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetViewResponse.Builder builder = GetViewResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                if (response.getStatusCode() != 304) {
                    builder.view((View)response.getItem());
                    builder.isNotModified(false);
                } else {
                    builder.isNotModified(true);
                }
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetViewResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

