/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.RRSet;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRRSetConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRRSetConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRRSetRequest interceptRequest(GetRRSetRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRRSetRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getZoneNameOrId(), (String)"zoneNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDomain(), (String)"domain must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRtype(), (String)"rtype must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("zones").path(HttpUtils.encodePathSegment((String)request.getZoneNameOrId())).path("records").path(HttpUtils.encodePathSegment((String)request.getDomain())).path(HttpUtils.encodePathSegment((String)request.getRtype()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getZoneVersion() != null) {
            target = target.queryParam("zoneVersion", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getZoneVersion())});
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        if (request.getViewId() != null) {
            target = target.queryParam("viewId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getViewId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfNoneMatch() != null) {
            ib.header("If-None-Match", (Object)request.getIfNoneMatch());
        }
        if (request.getIfModifiedSince() != null) {
            ib.header("If-Modified-Since", (Object)request.getIfModifiedSince());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetRRSetResponse> fromResponse() {
        Function<Response, GetRRSetResponse> transformer = new Function<Response, GetRRSetResponse>(){

            public GetRRSetResponse apply(Response rawResponse) {
                Optional eTagHeader;
                Optional opcRequestIdHeader;
                Optional opcTotalItemsHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.GetRRSetResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RRSet.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRRSetResponse.Builder builder = GetRRSetResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.rRSet((RRSet)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-total-items")).isPresent()) {
                    builder.opcTotalItems((Integer)HeaderUtils.toValue((String)"opc-total-items", (String)((String)((List)opcTotalItemsHeader.get()).get(0)), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                GetRRSetResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

