/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSteeringPolicyAttachmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteSteeringPolicyAttachmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteSteeringPolicyAttachmentRequest interceptRequest(DeleteSteeringPolicyAttachmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteSteeringPolicyAttachmentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSteeringPolicyAttachmentId(), (String)"steeringPolicyAttachmentId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("steeringPolicyAttachments").path(HttpUtils.encodePathSegment((String)request.getSteeringPolicyAttachmentId()));
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("If-Match", (Object)request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", (Object)request.getIfUnmodifiedSince());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteSteeringPolicyAttachmentResponse> fromResponse() {
        Function<Response, DeleteSteeringPolicyAttachmentResponse> transformer = new Function<Response, DeleteSteeringPolicyAttachmentResponse>(){

            public DeleteSteeringPolicyAttachmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteSteeringPolicyAttachmentResponse.Builder builder = DeleteSteeringPolicyAttachmentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteSteeringPolicyAttachmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

