/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.dns.requests.CreateResolverEndpointRequest;
import com.oracle.bmc.dns.responses.CreateResolverEndpointResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateResolverEndpointConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateResolverEndpointConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateResolverEndpointRequest interceptRequest(CreateResolverEndpointRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateResolverEndpointRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getResolverId(), (String)"resolverId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateResolverEndpointDetails(), (String)"createResolverEndpointDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("resolvers").path(HttpUtils.encodePathSegment((String)request.getResolverId())).path("endpoints");
        if (request.getScope() != null) {
            target = target.queryParam("scope", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScope().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateResolverEndpointResponse> fromResponse() {
        Function<Response, CreateResolverEndpointResponse> transformer = new Function<Response, CreateResolverEndpointResponse>(){

            public CreateResolverEndpointResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                Optional locationHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dns.responses.CreateResolverEndpointResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ResolverEndpoint.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateResolverEndpointResponse.Builder builder = CreateResolverEndpointResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.resolverEndpoint((ResolverEndpoint)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Location")).isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"Location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                CreateResolverEndpointResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

