/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dns.DnsAsync;
import com.oracle.bmc.dns.internal.http.ChangeResolverCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeSteeringPolicyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeTsigKeyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeViewCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeZoneCompartmentConverter;
import com.oracle.bmc.dns.internal.http.CreateResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.CreateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.CreateViewConverter;
import com.oracle.bmc.dns.internal.http.CreateZoneConverter;
import com.oracle.bmc.dns.internal.http.DeleteDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.DeleteRRSetConverter;
import com.oracle.bmc.dns.internal.http.DeleteResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.DeleteTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.DeleteViewConverter;
import com.oracle.bmc.dns.internal.http.DeleteZoneConverter;
import com.oracle.bmc.dns.internal.http.GetDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.GetRRSetConverter;
import com.oracle.bmc.dns.internal.http.GetResolverConverter;
import com.oracle.bmc.dns.internal.http.GetResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.GetTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.GetViewConverter;
import com.oracle.bmc.dns.internal.http.GetZoneConverter;
import com.oracle.bmc.dns.internal.http.GetZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.ListResolverEndpointsConverter;
import com.oracle.bmc.dns.internal.http.ListResolversConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPoliciesConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPolicyAttachmentsConverter;
import com.oracle.bmc.dns.internal.http.ListTsigKeysConverter;
import com.oracle.bmc.dns.internal.http.ListViewsConverter;
import com.oracle.bmc.dns.internal.http.ListZonesConverter;
import com.oracle.bmc.dns.internal.http.PatchDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.PatchRRSetConverter;
import com.oracle.bmc.dns.internal.http.PatchZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateRRSetConverter;
import com.oracle.bmc.dns.internal.http.UpdateResolverConverter;
import com.oracle.bmc.dns.internal.http.UpdateResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.UpdateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.UpdateViewConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneRecordsConverter;
import com.oracle.bmc.dns.requests.ChangeResolverCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeTsigKeyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeViewCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateTsigKeyRequest;
import com.oracle.bmc.dns.requests.CreateViewRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteDomainRecordsRequest;
import com.oracle.bmc.dns.requests.DeleteRRSetRequest;
import com.oracle.bmc.dns.requests.DeleteResolverEndpointRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteTsigKeyRequest;
import com.oracle.bmc.dns.requests.DeleteViewRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetResolverEndpointRequest;
import com.oracle.bmc.dns.requests.GetResolverRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.ListResolverEndpointsRequest;
import com.oracle.bmc.dns.requests.ListResolversRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListTsigKeysRequest;
import com.oracle.bmc.dns.requests.ListViewsRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.requests.PatchDomainRecordsRequest;
import com.oracle.bmc.dns.requests.PatchRRSetRequest;
import com.oracle.bmc.dns.requests.PatchZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateDomainRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.requests.UpdateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.UpdateResolverRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.requests.UpdateViewRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeResolverCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeTsigKeyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeViewCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateTsigKeyResponse;
import com.oracle.bmc.dns.responses.CreateViewResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteDomainRecordsResponse;
import com.oracle.bmc.dns.responses.DeleteRRSetResponse;
import com.oracle.bmc.dns.responses.DeleteResolverEndpointResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteTsigKeyResponse;
import com.oracle.bmc.dns.responses.DeleteViewResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetResolverEndpointResponse;
import com.oracle.bmc.dns.responses.GetResolverResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.ListResolverEndpointsResponse;
import com.oracle.bmc.dns.responses.ListResolversResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListTsigKeysResponse;
import com.oracle.bmc.dns.responses.ListViewsResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.dns.responses.PatchDomainRecordsResponse;
import com.oracle.bmc.dns.responses.PatchRRSetResponse;
import com.oracle.bmc.dns.responses.PatchZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateDomainRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.UpdateResolverResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.dns.responses.UpdateViewResponse;
import com.oracle.bmc.dns.responses.UpdateZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsAsyncClient
implements DnsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DnsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DNS").serviceEndpointPrefix("dns").serviceEndpointTemplate("https://dns.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DnsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DnsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeResolverCompartmentResponse> changeResolverCompartment(ChangeResolverCompartmentRequest request, AsyncHandler<ChangeResolverCompartmentRequest, ChangeResolverCompartmentResponse> handler) {
        LOG.trace("Called async changeResolverCompartment");
        ChangeResolverCompartmentRequest interceptedRequest = ChangeResolverCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeResolverCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeResolverCompartmentResponse> transformer = ChangeResolverCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeResolverCompartmentRequest, ChangeResolverCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeResolverCompartmentRequest, ChangeResolverCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeSteeringPolicyCompartmentResponse> changeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request, AsyncHandler<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> handler) {
        LOG.trace("Called async changeSteeringPolicyCompartment");
        ChangeSteeringPolicyCompartmentRequest interceptedRequest = ChangeSteeringPolicyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSteeringPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSteeringPolicyCompartmentResponse> transformer = ChangeSteeringPolicyCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeTsigKeyCompartmentResponse> changeTsigKeyCompartment(ChangeTsigKeyCompartmentRequest request, AsyncHandler<ChangeTsigKeyCompartmentRequest, ChangeTsigKeyCompartmentResponse> handler) {
        LOG.trace("Called async changeTsigKeyCompartment");
        ChangeTsigKeyCompartmentRequest interceptedRequest = ChangeTsigKeyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTsigKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTsigKeyCompartmentResponse> transformer = ChangeTsigKeyCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeTsigKeyCompartmentRequest, ChangeTsigKeyCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeTsigKeyCompartmentRequest, ChangeTsigKeyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeViewCompartmentResponse> changeViewCompartment(ChangeViewCompartmentRequest request, AsyncHandler<ChangeViewCompartmentRequest, ChangeViewCompartmentResponse> handler) {
        LOG.trace("Called async changeViewCompartment");
        ChangeViewCompartmentRequest interceptedRequest = ChangeViewCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeViewCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeViewCompartmentResponse> transformer = ChangeViewCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeViewCompartmentRequest, ChangeViewCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeViewCompartmentRequest, ChangeViewCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeZoneCompartmentResponse> changeZoneCompartment(ChangeZoneCompartmentRequest request, AsyncHandler<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> handler) {
        LOG.trace("Called async changeZoneCompartment");
        ChangeZoneCompartmentRequest interceptedRequest = ChangeZoneCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeZoneCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeZoneCompartmentResponse> transformer = ChangeZoneCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateResolverEndpointResponse> createResolverEndpoint(CreateResolverEndpointRequest request, AsyncHandler<CreateResolverEndpointRequest, CreateResolverEndpointResponse> handler) {
        LOG.trace("Called async createResolverEndpoint");
        CreateResolverEndpointRequest interceptedRequest = CreateResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateResolverEndpointResponse> transformer = CreateResolverEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateResolverEndpointRequest, CreateResolverEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateResolverEndpointRequest, CreateResolverEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSteeringPolicyResponse> createSteeringPolicy(CreateSteeringPolicyRequest request, AsyncHandler<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> handler) {
        LOG.trace("Called async createSteeringPolicy");
        CreateSteeringPolicyRequest interceptedRequest = CreateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyResponse> transformer = CreateSteeringPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSteeringPolicyAttachmentResponse> createSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request, AsyncHandler<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async createSteeringPolicyAttachment");
        CreateSteeringPolicyAttachmentRequest interceptedRequest = CreateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyAttachmentResponse> transformer = CreateSteeringPolicyAttachmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTsigKeyResponse> createTsigKey(CreateTsigKeyRequest request, AsyncHandler<CreateTsigKeyRequest, CreateTsigKeyResponse> handler) {
        LOG.trace("Called async createTsigKey");
        CreateTsigKeyRequest interceptedRequest = CreateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTsigKeyResponse> transformer = CreateTsigKeyConverter.fromResponse();
        AsyncHandler<CreateTsigKeyRequest, CreateTsigKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTsigKeyRequest, CreateTsigKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateViewResponse> createView(CreateViewRequest request, AsyncHandler<CreateViewRequest, CreateViewResponse> handler) {
        LOG.trace("Called async createView");
        CreateViewRequest interceptedRequest = CreateViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateViewResponse> transformer = CreateViewConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateViewRequest, CreateViewResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateViewRequest, CreateViewResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateZoneResponse> createZone(CreateZoneRequest request, AsyncHandler<CreateZoneRequest, CreateZoneResponse> handler) {
        LOG.trace("Called async createZone");
        CreateZoneRequest interceptedRequest = CreateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateZoneResponse> transformer = CreateZoneConverter.fromResponse();
        AsyncHandler<CreateZoneRequest, CreateZoneResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateZoneRequest, CreateZoneResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDomainRecordsResponse> deleteDomainRecords(DeleteDomainRecordsRequest request, AsyncHandler<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> handler) {
        LOG.trace("Called async deleteDomainRecords");
        DeleteDomainRecordsRequest interceptedRequest = DeleteDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDomainRecordsResponse> transformer = DeleteDomainRecordsConverter.fromResponse();
        AsyncHandler<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDomainRecordsRequest, DeleteDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRRSetResponse> deleteRRSet(DeleteRRSetRequest request, AsyncHandler<DeleteRRSetRequest, DeleteRRSetResponse> handler) {
        LOG.trace("Called async deleteRRSet");
        DeleteRRSetRequest interceptedRequest = DeleteRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRRSetResponse> transformer = DeleteRRSetConverter.fromResponse();
        AsyncHandler<DeleteRRSetRequest, DeleteRRSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRRSetRequest, DeleteRRSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteResolverEndpointResponse> deleteResolverEndpoint(DeleteResolverEndpointRequest request, AsyncHandler<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse> handler) {
        LOG.trace("Called async deleteResolverEndpoint");
        DeleteResolverEndpointRequest interceptedRequest = DeleteResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteResolverEndpointResponse> transformer = DeleteResolverEndpointConverter.fromResponse();
        AsyncHandler<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSteeringPolicyResponse> deleteSteeringPolicy(DeleteSteeringPolicyRequest request, AsyncHandler<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> handler) {
        LOG.trace("Called async deleteSteeringPolicy");
        DeleteSteeringPolicyRequest interceptedRequest = DeleteSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyResponse> transformer = DeleteSteeringPolicyConverter.fromResponse();
        AsyncHandler<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSteeringPolicyAttachmentResponse> deleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request, AsyncHandler<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async deleteSteeringPolicyAttachment");
        DeleteSteeringPolicyAttachmentRequest interceptedRequest = DeleteSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyAttachmentResponse> transformer = DeleteSteeringPolicyAttachmentConverter.fromResponse();
        AsyncHandler<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTsigKeyResponse> deleteTsigKey(DeleteTsigKeyRequest request, AsyncHandler<DeleteTsigKeyRequest, DeleteTsigKeyResponse> handler) {
        LOG.trace("Called async deleteTsigKey");
        DeleteTsigKeyRequest interceptedRequest = DeleteTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTsigKeyResponse> transformer = DeleteTsigKeyConverter.fromResponse();
        AsyncHandler<DeleteTsigKeyRequest, DeleteTsigKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTsigKeyRequest, DeleteTsigKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteViewResponse> deleteView(DeleteViewRequest request, AsyncHandler<DeleteViewRequest, DeleteViewResponse> handler) {
        LOG.trace("Called async deleteView");
        DeleteViewRequest interceptedRequest = DeleteViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteViewResponse> transformer = DeleteViewConverter.fromResponse();
        AsyncHandler<DeleteViewRequest, DeleteViewResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteViewRequest, DeleteViewResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteZoneResponse> deleteZone(DeleteZoneRequest request, AsyncHandler<DeleteZoneRequest, DeleteZoneResponse> handler) {
        LOG.trace("Called async deleteZone");
        DeleteZoneRequest interceptedRequest = DeleteZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteZoneResponse> transformer = DeleteZoneConverter.fromResponse();
        AsyncHandler<DeleteZoneRequest, DeleteZoneResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteZoneRequest, DeleteZoneResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDomainRecordsResponse> getDomainRecords(GetDomainRecordsRequest request, AsyncHandler<GetDomainRecordsRequest, GetDomainRecordsResponse> handler) {
        LOG.trace("Called async getDomainRecords");
        GetDomainRecordsRequest interceptedRequest = GetDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDomainRecordsResponse> transformer = GetDomainRecordsConverter.fromResponse();
        AsyncHandler<GetDomainRecordsRequest, GetDomainRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDomainRecordsRequest, GetDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRRSetResponse> getRRSet(GetRRSetRequest request, AsyncHandler<GetRRSetRequest, GetRRSetResponse> handler) {
        LOG.trace("Called async getRRSet");
        GetRRSetRequest interceptedRequest = GetRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRRSetResponse> transformer = GetRRSetConverter.fromResponse();
        AsyncHandler<GetRRSetRequest, GetRRSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRRSetRequest, GetRRSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResolverResponse> getResolver(GetResolverRequest request, AsyncHandler<GetResolverRequest, GetResolverResponse> handler) {
        LOG.trace("Called async getResolver");
        GetResolverRequest interceptedRequest = GetResolverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResolverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResolverResponse> transformer = GetResolverConverter.fromResponse();
        AsyncHandler<GetResolverRequest, GetResolverResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResolverRequest, GetResolverResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetResolverEndpointResponse> getResolverEndpoint(GetResolverEndpointRequest request, AsyncHandler<GetResolverEndpointRequest, GetResolverEndpointResponse> handler) {
        LOG.trace("Called async getResolverEndpoint");
        GetResolverEndpointRequest interceptedRequest = GetResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResolverEndpointResponse> transformer = GetResolverEndpointConverter.fromResponse();
        AsyncHandler<GetResolverEndpointRequest, GetResolverEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetResolverEndpointRequest, GetResolverEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSteeringPolicyResponse> getSteeringPolicy(GetSteeringPolicyRequest request, AsyncHandler<GetSteeringPolicyRequest, GetSteeringPolicyResponse> handler) {
        LOG.trace("Called async getSteeringPolicy");
        GetSteeringPolicyRequest interceptedRequest = GetSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyResponse> transformer = GetSteeringPolicyConverter.fromResponse();
        AsyncHandler<GetSteeringPolicyRequest, GetSteeringPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSteeringPolicyRequest, GetSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSteeringPolicyAttachmentResponse> getSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, AsyncHandler<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async getSteeringPolicyAttachment");
        GetSteeringPolicyAttachmentRequest interceptedRequest = GetSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyAttachmentResponse> transformer = GetSteeringPolicyAttachmentConverter.fromResponse();
        AsyncHandler<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTsigKeyResponse> getTsigKey(GetTsigKeyRequest request, AsyncHandler<GetTsigKeyRequest, GetTsigKeyResponse> handler) {
        LOG.trace("Called async getTsigKey");
        GetTsigKeyRequest interceptedRequest = GetTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTsigKeyResponse> transformer = GetTsigKeyConverter.fromResponse();
        AsyncHandler<GetTsigKeyRequest, GetTsigKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTsigKeyRequest, GetTsigKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetViewResponse> getView(GetViewRequest request, AsyncHandler<GetViewRequest, GetViewResponse> handler) {
        LOG.trace("Called async getView");
        GetViewRequest interceptedRequest = GetViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetViewResponse> transformer = GetViewConverter.fromResponse();
        AsyncHandler<GetViewRequest, GetViewResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetViewRequest, GetViewResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetZoneResponse> getZone(GetZoneRequest request, AsyncHandler<GetZoneRequest, GetZoneResponse> handler) {
        LOG.trace("Called async getZone");
        GetZoneRequest interceptedRequest = GetZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneResponse> transformer = GetZoneConverter.fromResponse();
        AsyncHandler<GetZoneRequest, GetZoneResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetZoneRequest, GetZoneResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetZoneRecordsResponse> getZoneRecords(GetZoneRecordsRequest request, AsyncHandler<GetZoneRecordsRequest, GetZoneRecordsResponse> handler) {
        LOG.trace("Called async getZoneRecords");
        GetZoneRecordsRequest interceptedRequest = GetZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneRecordsResponse> transformer = GetZoneRecordsConverter.fromResponse();
        AsyncHandler<GetZoneRecordsRequest, GetZoneRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetZoneRecordsRequest, GetZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResolverEndpointsResponse> listResolverEndpoints(ListResolverEndpointsRequest request, AsyncHandler<ListResolverEndpointsRequest, ListResolverEndpointsResponse> handler) {
        LOG.trace("Called async listResolverEndpoints");
        ListResolverEndpointsRequest interceptedRequest = ListResolverEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResolverEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResolverEndpointsResponse> transformer = ListResolverEndpointsConverter.fromResponse();
        AsyncHandler<ListResolverEndpointsRequest, ListResolverEndpointsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResolverEndpointsRequest, ListResolverEndpointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResolversResponse> listResolvers(ListResolversRequest request, AsyncHandler<ListResolversRequest, ListResolversResponse> handler) {
        LOG.trace("Called async listResolvers");
        ListResolversRequest interceptedRequest = ListResolversConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResolversConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResolversResponse> transformer = ListResolversConverter.fromResponse();
        AsyncHandler<ListResolversRequest, ListResolversResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResolversRequest, ListResolversResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSteeringPoliciesResponse> listSteeringPolicies(ListSteeringPoliciesRequest request, AsyncHandler<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> handler) {
        LOG.trace("Called async listSteeringPolicies");
        ListSteeringPoliciesRequest interceptedRequest = ListSteeringPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPoliciesResponse> transformer = ListSteeringPoliciesConverter.fromResponse();
        AsyncHandler<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSteeringPolicyAttachmentsResponse> listSteeringPolicyAttachments(ListSteeringPolicyAttachmentsRequest request, AsyncHandler<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> handler) {
        LOG.trace("Called async listSteeringPolicyAttachments");
        ListSteeringPolicyAttachmentsRequest interceptedRequest = ListSteeringPolicyAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPolicyAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = ListSteeringPolicyAttachmentsConverter.fromResponse();
        AsyncHandler<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTsigKeysResponse> listTsigKeys(ListTsigKeysRequest request, AsyncHandler<ListTsigKeysRequest, ListTsigKeysResponse> handler) {
        LOG.trace("Called async listTsigKeys");
        ListTsigKeysRequest interceptedRequest = ListTsigKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTsigKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTsigKeysResponse> transformer = ListTsigKeysConverter.fromResponse();
        AsyncHandler<ListTsigKeysRequest, ListTsigKeysResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTsigKeysRequest, ListTsigKeysResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListViewsResponse> listViews(ListViewsRequest request, AsyncHandler<ListViewsRequest, ListViewsResponse> handler) {
        LOG.trace("Called async listViews");
        ListViewsRequest interceptedRequest = ListViewsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListViewsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListViewsResponse> transformer = ListViewsConverter.fromResponse();
        AsyncHandler<ListViewsRequest, ListViewsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListViewsRequest, ListViewsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListZonesResponse> listZones(ListZonesRequest request, AsyncHandler<ListZonesRequest, ListZonesResponse> handler) {
        LOG.trace("Called async listZones");
        ListZonesRequest interceptedRequest = ListZonesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListZonesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListZonesResponse> transformer = ListZonesConverter.fromResponse();
        AsyncHandler<ListZonesRequest, ListZonesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListZonesRequest, ListZonesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PatchDomainRecordsResponse> patchDomainRecords(PatchDomainRecordsRequest request, AsyncHandler<PatchDomainRecordsRequest, PatchDomainRecordsResponse> handler) {
        LOG.trace("Called async patchDomainRecords");
        PatchDomainRecordsRequest interceptedRequest = PatchDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchDomainRecordsResponse> transformer = PatchDomainRecordsConverter.fromResponse();
        AsyncHandler<PatchDomainRecordsRequest, PatchDomainRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.patchFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PatchDomainRecordsRequest, PatchDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PatchRRSetResponse> patchRRSet(PatchRRSetRequest request, AsyncHandler<PatchRRSetRequest, PatchRRSetResponse> handler) {
        LOG.trace("Called async patchRRSet");
        PatchRRSetRequest interceptedRequest = PatchRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchRRSetResponse> transformer = PatchRRSetConverter.fromResponse();
        AsyncHandler<PatchRRSetRequest, PatchRRSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.patchFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PatchRRSetRequest, PatchRRSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PatchZoneRecordsResponse> patchZoneRecords(PatchZoneRecordsRequest request, AsyncHandler<PatchZoneRecordsRequest, PatchZoneRecordsResponse> handler) {
        LOG.trace("Called async patchZoneRecords");
        PatchZoneRecordsRequest interceptedRequest = PatchZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchZoneRecordsResponse> transformer = PatchZoneRecordsConverter.fromResponse();
        AsyncHandler<PatchZoneRecordsRequest, PatchZoneRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.patchFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PatchZoneRecordsRequest, PatchZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDomainRecordsResponse> updateDomainRecords(UpdateDomainRecordsRequest request, AsyncHandler<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> handler) {
        LOG.trace("Called async updateDomainRecords");
        UpdateDomainRecordsRequest interceptedRequest = UpdateDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDomainRecordsResponse> transformer = UpdateDomainRecordsConverter.fromResponse();
        AsyncHandler<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDomainRecordsRequest, UpdateDomainRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRRSetResponse> updateRRSet(UpdateRRSetRequest request, AsyncHandler<UpdateRRSetRequest, UpdateRRSetResponse> handler) {
        LOG.trace("Called async updateRRSet");
        UpdateRRSetRequest interceptedRequest = UpdateRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRRSetResponse> transformer = UpdateRRSetConverter.fromResponse();
        AsyncHandler<UpdateRRSetRequest, UpdateRRSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRRSetRequest, UpdateRRSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateResolverResponse> updateResolver(UpdateResolverRequest request, AsyncHandler<UpdateResolverRequest, UpdateResolverResponse> handler) {
        LOG.trace("Called async updateResolver");
        UpdateResolverRequest interceptedRequest = UpdateResolverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResolverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResolverResponse> transformer = UpdateResolverConverter.fromResponse();
        AsyncHandler<UpdateResolverRequest, UpdateResolverResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateResolverRequest, UpdateResolverResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateResolverEndpointResponse> updateResolverEndpoint(UpdateResolverEndpointRequest request, AsyncHandler<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse> handler) {
        LOG.trace("Called async updateResolverEndpoint");
        UpdateResolverEndpointRequest interceptedRequest = UpdateResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResolverEndpointResponse> transformer = UpdateResolverEndpointConverter.fromResponse();
        AsyncHandler<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSteeringPolicyResponse> updateSteeringPolicy(UpdateSteeringPolicyRequest request, AsyncHandler<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> handler) {
        LOG.trace("Called async updateSteeringPolicy");
        UpdateSteeringPolicyRequest interceptedRequest = UpdateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyResponse> transformer = UpdateSteeringPolicyConverter.fromResponse();
        AsyncHandler<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSteeringPolicyAttachmentResponse> updateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request, AsyncHandler<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> handler) {
        LOG.trace("Called async updateSteeringPolicyAttachment");
        UpdateSteeringPolicyAttachmentRequest interceptedRequest = UpdateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyAttachmentResponse> transformer = UpdateSteeringPolicyAttachmentConverter.fromResponse();
        AsyncHandler<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTsigKeyResponse> updateTsigKey(UpdateTsigKeyRequest request, AsyncHandler<UpdateTsigKeyRequest, UpdateTsigKeyResponse> handler) {
        LOG.trace("Called async updateTsigKey");
        UpdateTsigKeyRequest interceptedRequest = UpdateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTsigKeyResponse> transformer = UpdateTsigKeyConverter.fromResponse();
        AsyncHandler<UpdateTsigKeyRequest, UpdateTsigKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTsigKeyRequest, UpdateTsigKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateViewResponse> updateView(UpdateViewRequest request, AsyncHandler<UpdateViewRequest, UpdateViewResponse> handler) {
        LOG.trace("Called async updateView");
        UpdateViewRequest interceptedRequest = UpdateViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateViewResponse> transformer = UpdateViewConverter.fromResponse();
        AsyncHandler<UpdateViewRequest, UpdateViewResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateViewRequest, UpdateViewResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateZoneResponse> updateZone(UpdateZoneRequest request, AsyncHandler<UpdateZoneRequest, UpdateZoneResponse> handler) {
        LOG.trace("Called async updateZone");
        UpdateZoneRequest interceptedRequest = UpdateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneResponse> transformer = UpdateZoneConverter.fromResponse();
        AsyncHandler<UpdateZoneRequest, UpdateZoneResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateZoneRequest, UpdateZoneResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateZoneRecordsResponse> updateZoneRecords(UpdateZoneRecordsRequest request, AsyncHandler<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> handler) {
        LOG.trace("Called async updateZoneRecords");
        UpdateZoneRecordsRequest interceptedRequest = UpdateZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneRecordsResponse> transformer = UpdateZoneRecordsConverter.fromResponse();
        AsyncHandler<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateZoneRecordsRequest, UpdateZoneRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DnsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DnsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DnsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

