/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.okeworkloadidentity;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.DefaultServiceAccountTokenProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.ServiceAccountTokenSupplier;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.SuppliedServiceAccountTokenProvider;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.okeworkloadidentity.internal.OkeTenancyOnlyAuthenticationDetailsProvider;
import com.oracle.bmc.auth.okeworkloadidentity.internal.OkeWorkloadIdentityResourcePrincipalsFederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.StandardClientProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class OkeWorkloadIdentityAuthenticationDetailsProvider
extends AbstractRequestingAuthenticationDetailsProvider
implements RegionProvider,
RefreshableOnNotAuthenticatedProvider<String>,
ProvidesConfigurableRefresh {
    private final Region region;
    private static final String DEFAULT_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV = "OCI_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH";

    private OkeWorkloadIdentityAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier);
        this.region = region;
    }

    public static OkeWorkloadIdentityAuthenticationDetailsProviderBuilder builder() {
        return new OkeWorkloadIdentityAuthenticationDetailsProviderBuilder();
    }

    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    public Region getRegion() {
        return this.region;
    }

    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        if (this.federationClient instanceof ProvidesConfigurableRefresh) {
            return ((ProvidesConfigurableRefresh)this.federationClient).refreshAndGetSecurityTokenIfExpiringWithin(time);
        }
        return this.federationClient.refreshAndGetSecurityToken();
    }

    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time, boolean refreshKeys) {
        if (this.federationClient instanceof ProvidesConfigurableRefresh) {
            return ((ProvidesConfigurableRefresh)this.federationClient).refreshAndGetSecurityTokenIfExpiringWithin(time, refreshKeys);
        }
        return this.federationClient.refreshAndGetSecurityToken();
    }

    public static class OkeWorkloadIdentityAuthenticationDetailsProviderBuilder
    extends AbstractFederationClientAuthenticationDetailsProviderBuilder<OkeWorkloadIdentityAuthenticationDetailsProviderBuilder, OkeWorkloadIdentityAuthenticationDetailsProvider> {
        private CircuitBreakerConfiguration circuitBreakerConfig;
        private ServiceAccountTokenSupplier serviceAccountTokenSupplier = new DefaultServiceAccountTokenProvider();

        public OkeWorkloadIdentityAuthenticationDetailsProviderBuilder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            return this;
        }

        public OkeWorkloadIdentityAuthenticationDetailsProviderBuilder circuitBreakerConfig(CircuitBreakerConfiguration circuitBreakerConfig) {
            this.circuitBreakerConfig = circuitBreakerConfig;
            return this;
        }

        public OkeWorkloadIdentityAuthenticationDetailsProviderBuilder token(String token) {
            this.serviceAccountTokenSupplier = new SuppliedServiceAccountTokenProvider(token);
            return this;
        }

        public OkeWorkloadIdentityAuthenticationDetailsProviderBuilder tokenPath(String tokenPath) {
            this.serviceAccountTokenSupplier = new DefaultServiceAccountTokenProvider(tokenPath);
            return this;
        }

        public OkeWorkloadIdentityAuthenticationDetailsProviderBuilder tokenPath(ServiceAccountTokenSupplier serviceAccountTokenSupplier) {
            this.serviceAccountTokenSupplier = serviceAccountTokenSupplier;
            return this;
        }

        public OkeWorkloadIdentityAuthenticationDetailsProvider build() {
            this.autoDetectEndpointUsingMetadataUrl();
            return (OkeWorkloadIdentityAuthenticationDetailsProvider)super.build();
        }

        protected FederationClient createFederationClient(SessionKeySupplier sessionKeySupplier) {
            SSLContext sslCtx;
            String kubernetesCaCertPath;
            OkeTenancyOnlyAuthenticationDetailsProvider provider = new OkeTenancyOnlyAuthenticationDetailsProvider();
            String string = kubernetesCaCertPath = System.getenv(OkeWorkloadIdentityAuthenticationDetailsProvider.KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV) != null ? System.getenv(OkeWorkloadIdentityAuthenticationDetailsProvider.KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV) : OkeWorkloadIdentityAuthenticationDetailsProvider.DEFAULT_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH;
            if (Files.exists(Paths.get(kubernetesCaCertPath, new String[0]), new LinkOption[0])) {
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(Paths.get(kubernetesCaCertPath, new String[0]).toFile());
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(inputStream);
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(null, null);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    keyStore.setCertificateEntry("ocp-cert", certificate);
                    tmf.init(keyStore);
                    sslCtx = SSLContext.getInstance("TLS");
                    sslCtx.init(null, tmf.getTrustManagers(), null);
                }
                catch (CertificateException e) {
                    throw new IllegalArgumentException("Invalid Kubernetes ca certification. Please contact OKE Foundation team for help.", e);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("Kubernetes service account ca cert doesn't exist.", e);
                }
                catch (KeyStoreException e) {
                    throw new IllegalArgumentException("Cannot create keystore based on Kubernetes ca cert. Please contact OKE Foundation team for help.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load keystore. Please contact OKE Foundation team for help.", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Cannot load keystore. Please contact OKE Foundation team for help.", e);
                }
                catch (KeyManagementException e) {
                    throw new IllegalArgumentException("Failed to load ssl context when trying to request rpst token. Please contact OKE Foundation team for help.", e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Kubernetes service account ca cert doesn't exist.", e);
                    }
                }
            }
            throw new IllegalArgumentException("Kubernetes service account ca cert doesn't exist.");
            ClientConfigurator configurator = builder -> {
                builder.property(StandardClientProperties.HOSTNAME_VERIFIER, (Object)new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }

                    public final String toString() {
                        return "NO_OP";
                    }
                });
                builder.property(StandardClientProperties.SSL_CONTEXT, (Object)sslCtx);
                builder.property(StandardClientProperties.BUFFER_REQUEST, (Object)false);
            };
            ArrayList<ClientConfigurator> additionalConfigurators = new ArrayList<ClientConfigurator>();
            if (this.federationClientConfigurator != null) {
                additionalConfigurators.add(this.federationClientConfigurator);
            }
            additionalConfigurators.addAll(this.additionalFederationClientConfigurators);
            return new OkeWorkloadIdentityResourcePrincipalsFederationClient(sessionKeySupplier, this.serviceAccountTokenSupplier, provider, configurator, this.circuitBreakerConfig, additionalConfigurators);
        }

        protected OkeWorkloadIdentityAuthenticationDetailsProvider buildProvider(SessionKeySupplier sessionKeySupplierToUse) {
            return new OkeWorkloadIdentityAuthenticationDetailsProvider(this.federationClient, sessionKeySupplierToUse, this.region);
        }
    }
}

