/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import oracle.xml.common.format.IntegerFormatter;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLCompatible;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

class XSLNumber
extends XSLNode
implements XSLConstants {
    private static final String SINGLE = "single";
    private static final String MULTIPLE = "multiple";
    private static final String ANY = "any";
    private static final String ALPHABETIC = "alphabetic";
    private static final String TRADITIONAL = "traditional";
    private static final String LEVEL = "level";
    private static final String COUNT = "count";
    private static final String FROM = "from";
    private static final String VALUE = "value";
    private static final String FORMAT = "format";
    private static final String LANG = "lang";
    private static final String LETTER_VALUE = "letter-value";
    private static final String GROUPING_SEPARATOR = "grouping-separator";
    private static final String GROUPING_SIZE = "grouping-size";
    private static final String ORDINAL = "ordinal";
    private static final String XSLNUMBER = "xsl:number";
    private static final String LEFT_BRACKET = "{";
    String m_strValue = null;
    String m_strCount = null;
    String m_strFrom = null;
    String m_strLevel = null;
    boolean m_blnIsMul = true;
    XSLNode.AttrValueTmpl m_avtLang = null;
    XSLExprBase select;
    boolean ordinal = false;
    XSLNode.AttrValueTmpl m_avtLetterValue;
    XSLNode.AttrValueTmpl m_avtFormat;
    XSLNode.AttrValueTmpl m_avtGroupingSeparator;
    XSLNode.AttrValueTmpl m_avtGroupingSize;
    XSLExprBase m_stringValue = null;
    XSLExprBase m_countPattern = null;
    int m_intCountAnchorType = -1;
    String[] m_countAnchorName = new String[2];
    String m_countAnchorLocalName = null;
    String m_countAnchorNamespace = null;
    XSLExprBase m_fromPattern = null;
    int m_intFromAnchorType = -1;
    String[] m_fromAnchorName = new String[2];
    String m_fromAnchorLocalName = null;
    String m_fromAnchorNamespace = null;
    private static final Integer DEC_FORMAT = new Integer(1);
    private static final Integer ALU_FORMAT = new Integer(2);
    private static final Integer ALL_FORMAT = new Integer(3);
    private static final Integer RMU_FORMAT = new Integer(4);
    private static final Integer RML_FORMAT = new Integer(5);
    private static final Integer NML_FORMAT = new Integer(6);
    private static final Integer NMU_FORMAT = new Integer(7);
    private static final Integer NMT_FORMAT = new Integer(8);

    private int getFormatPrefix(char[] cArray, int n, NumberProperties numberProperties) throws XSLException {
        int n2 = 0;
        if (!Character.isLetterOrDigit(cArray[n2])) {
            while (n2 < n && !Character.isLetterOrDigit(cArray[n2])) {
                ++n2;
            }
            numberProperties.prefix = new String(cArray, 0, n2);
        }
        if (n2 == n) {
            this.addDefaultElement(numberProperties.formats);
            return -1;
        }
        return n2;
    }

    private int getFormatPostfix(char[] cArray, int n, NumberProperties numberProperties) throws XSLException {
        int n2;
        for (n2 = n - 1; n2 >= 0 && !Character.isLetterOrDigit(cArray[n2]); --n2) {
        }
        if (n2 != n - 1) {
            numberProperties.postfix = new String(cArray, n2 + 1, n - n2 - 1);
            n = n2 + 1;
        }
        return n;
    }

    private boolean isPureDigits(char[] cArray, int n, FastVector fastVector) throws XSLException {
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            this.addDefaultElement(fastVector);
            return false;
        }
        return true;
    }

    private void getFormatDigits(char[] cArray, int n, FastVector fastVector) throws XSLException {
        int n2;
        if (!this.isPureDigits(cArray, n, fastVector)) {
            return;
        }
        int n3 = 0;
        for (n2 = 0; n2 < n && cArray[n2] == '0'; ++n2) {
            ++n3;
        }
        String string = n2 == 0 ? new String(cArray) : new String(cArray, n2, n - n3);
        fastVector.addElement(DEC_FORMAT);
        fastVector.addElement(new Integer(n3));
        fastVector.addElement(new Integer(string));
    }

    private void addDefaultElement(FastVector fastVector) throws XSLException {
        fastVector.addElement(DEC_FORMAT);
        fastVector.addElement(new Integer(0));
        fastVector.addElement(new Integer(1));
    }

    private void processAlpPureUpperLetters(char[] cArray, int n, FastVector fastVector) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c > '@' && c < '[') continue;
            this.addDefaultElement(fastVector);
            return;
        }
        String string = new String(cArray);
        fastVector.addElement(ALU_FORMAT);
        fastVector.addElement(string);
    }

    private void processAlpPureLowerLetters(char[] cArray, int n, FastVector fastVector) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c > '`' && c < '{') continue;
            this.addDefaultElement(fastVector);
            return;
        }
        String string = new String(cArray);
        fastVector.addElement(ALL_FORMAT);
        fastVector.addElement(string);
    }

    private void processRomanPureLowerNumbers(char[] cArray, int n, FastVector fastVector) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c == 'i' || c == 'v' || c == 'x' || c == 'l' || c == 'c' || c == 'd' || c == 'm' || c == 'p') continue;
            this.processAlpPureLowerLetters(cArray, n, fastVector);
            return;
        }
        String string = new String(cArray);
        fastVector.addElement(RML_FORMAT);
        fastVector.addElement(string);
    }

    private void processRomanPureUpperNumbers(char[] cArray, int n, FastVector fastVector) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c == 'I' || c == 'V' || c == 'X' || c == 'L' || c == 'C' || c == 'D' || c == 'M' || c == 'P') continue;
            this.processAlpPureUpperLetters(cArray, n, fastVector);
            return;
        }
        String string = new String(cArray);
        fastVector.addElement(RMU_FORMAT);
        fastVector.addElement(string);
    }

    private void processNamedNumber(char[] cArray, int n, FastVector fastVector) {
        char c = cArray[0];
        if (c == 'w') {
            fastVector.addElement(NML_FORMAT);
        } else if (c == 'W') {
            if (n > 1 && cArray[1] == 'w') {
                fastVector.addElement(NMT_FORMAT);
            } else {
                fastVector.addElement(NMU_FORMAT);
            }
        }
        String string = new String(cArray);
        fastVector.addElement(string);
    }

    private void parseFormatString(String string, NumberProperties numberProperties) throws XSLException {
        numberProperties.formats = new FastVector();
        if (string == null || string.length() == 0) {
            this.addDefaultElement(numberProperties.formats);
            return;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        if (!this.m_blnIsMul) {
            this.parseFormatStringSglAny(cArray, n, numberProperties);
        } else {
            this.parseFormatStringMul(cArray, n, numberProperties);
        }
    }

    private void parseFormatStringMul(char[] cArray, int n, NumberProperties numberProperties) throws XSLException {
        numberProperties.separators = new Vector(5, 5);
        int n2 = 0;
        String string = "";
        String string2 = "";
        boolean bl = false;
        this.getFormatPostfix(cArray, n, numberProperties);
        char c = cArray[n2++];
        if (Character.isLetterOrDigit(c)) {
            string = string + c;
        } else {
            string2 = string2 + c;
            bl = true;
        }
        while (n2 < n) {
            char c2 = cArray[n2++];
            if (Character.isLetterOrDigit(c) && Character.isLetterOrDigit(c2)) {
                string = string + c2;
            } else if (Character.isLetterOrDigit(c) && !Character.isLetterOrDigit(c2)) {
                this.parseFormatStringSglAny(string.toCharArray(), string.length(), numberProperties);
                string = "";
                string2 = String.valueOf(c2);
            } else if (!Character.isLetterOrDigit(c) && !Character.isLetterOrDigit(c2)) {
                string2 = string2 + c2;
            } else if (!Character.isLetterOrDigit(c) && Character.isLetterOrDigit(c2)) {
                numberProperties.separators.addElement(string2);
                string2 = "";
                string = String.valueOf(c2);
            }
            c = c2;
        }
        if (string != "") {
            this.parseFormatStringSglAny(string.toCharArray(), string.length(), numberProperties);
        }
        if (string2 != "") {
            numberProperties.separators.addElement(string2);
        }
        if (bl) {
            numberProperties.prefix = numberProperties.separators.elementAt(0).toString();
            numberProperties.separators.removeElementAt(0);
        }
    }

    private void parseFormatStringSglAny(char[] cArray, int n, NumberProperties numberProperties) throws XSLException {
        int n2 = 0;
        n2 = this.getFormatPrefix(cArray, n, numberProperties);
        if (n2 == -1) {
            return;
        }
        char[] cArray2 = new char[n -= n2];
        System.arraycopy(cArray, n2, cArray2, 0, n);
        n = this.getFormatPostfix(cArray2, n, numberProperties);
        n2 = 0;
        char[] cArray3 = new char[n];
        System.arraycopy(cArray2, 0, cArray3, 0, n);
        if (Character.isDigit(cArray3[0])) {
            this.getFormatDigits(cArray3, n, numberProperties.formats);
        } else if (numberProperties.letterValue.equals(ALPHABETIC)) {
            char c = cArray3[0];
            if (c > '@' && c < '[') {
                this.processAlpPureUpperLetters(cArray3, n, numberProperties.formats);
            } else if (c > '`' && c < '{') {
                this.processAlpPureLowerLetters(cArray3, n, numberProperties.formats);
            } else {
                this.addDefaultElement(numberProperties.formats);
            }
        } else {
            char c = cArray3[0];
            char c2 = cArray3[0];
            if (c == 'i' || c == 'v' || c == 'x' || c == 'l' || c == 'c' || c == 'd' || c == 'm' || c == 'p') {
                this.processRomanPureLowerNumbers(cArray3, n, numberProperties.formats);
            } else if (c == 'I' || c == 'V' || c == 'X' || c == 'L' || c == 'C' || c == 'D' || c == 'M' || c == 'P') {
                this.processRomanPureUpperNumbers(cArray3, n, numberProperties.formats);
            } else if (c == 'W' || c == 'w') {
                this.processNamedNumber(cArray3, n, numberProperties.formats);
            } else if (c2 > '@' && c2 < '[') {
                this.processAlpPureUpperLetters(cArray3, n, numberProperties.formats);
            } else if (c2 > '`' && c2 < '{') {
                this.processAlpPureLowerLetters(cArray3, n, numberProperties.formats);
            } else {
                this.addDefaultElement(numberProperties.formats);
            }
        }
    }

    XSLNumber(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    private int[] getMultiCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode;
        FastVector fastVector = new FastVector();
        for (xMLNode = xSLTContext.getContextNode(); xMLNode != null && xMLNode.getNodeType() == 1 && (this.m_fromPattern == null || this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) == null); xMLNode = (XMLNode)xMLNode.getParentNode()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null) continue;
            fastVector.addElement(xMLNode);
        }
        int[] nArray = new int[fastVector.size()];
        int n = fastVector.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            nArray[n2] = 0;
            for (xMLNode = (XMLNode)fastVector.elementAt(n); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null || xMLNode.getNodeType() != 1) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
            }
            --n;
            ++n2;
        }
        return nArray;
    }

    private int getSingleCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode;
        int n = 0;
        XMLNode xMLNode2 = null;
        for (xMLNode = xSLTContext.getContextNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) != null) {
                if (xMLNode2 == null) {
                    xMLNode2 = xMLNode;
                }
                if (this.m_fromPattern == null) break;
            }
            if (this.m_fromPattern != null && this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) != null) break;
        }
        if (xMLNode2 == null) {
            return n;
        }
        for (xMLNode = xMLNode2; xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null || xMLNode.getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    private int getAnyCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode = xSLTContext.getContextNode();
        int n = 0;
        while (xMLNode != null && (this.m_fromPattern == null || this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) == null)) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) != null) {
                ++n;
            }
            xMLNode = XPathAxis.getProceedingNode(xMLNode);
        }
        return n;
    }

    private int alphaToNum(String string) throws XSLException {
        String string2 = string.toLowerCase();
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = cArray[i] - 97 + 1;
            n2 = n2 * 26 + n3;
        }
        return n2;
    }

    private static String numToAlpha(int n) throws XSLException {
        char[] cArray = new char[256];
        int n2 = cArray.length - 1;
        while (n > 26) {
            int n3 = n % 26;
            n /= 26;
            if (n3 == 0) {
                n3 = 26;
                --n;
            }
            cArray[n2--] = (char)(65 + n3 - 1);
        }
        if (n < 1) {
            return "";
        }
        cArray[n2--] = (char)(65 + n - 1);
        return new String(cArray, n2 + 1, cArray.length - n2 - 1);
    }

    private static String numToRoman(int n) throws XSLException {
        if (n == 0) {
            return "0";
        }
        String string = Integer.toString(n);
        String string2 = "";
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        int n3 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            string2 = string2 + XSLNumber.singleNumToRoman(c, n3);
            --n3;
        }
        return string2;
    }

    private static String singleNumToRoman(char c, int n) throws XSLException {
        int n2 = c - 48;
        String string = "";
        switch (n2) {
            case 1: {
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 2: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 3: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 4: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanFive(n);
                break;
            }
            case 5: {
                string = string + XSLNumber.saveRomanFive(n);
                break;
            }
            case 6: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 7: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 8: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 9: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanTen(n);
                break;
            }
        }
        return string;
    }

    private static String saveRomanOne(int n) throws XSLException {
        String string;
        switch (n) {
            case 0: {
                string = "I";
                break;
            }
            case 1: {
                string = "X";
                break;
            }
            case 2: {
                string = "C";
                break;
            }
            case 3: {
                string = "M";
                break;
            }
            case 4: {
                string = "(X)";
                break;
            }
            case 5: {
                string = "(C)";
                break;
            }
            case 6: {
                string = "(M)";
                break;
            }
            case 7: {
                string = "[X]";
                break;
            }
            case 8: {
                string = "[C]";
                break;
            }
            case 9: {
                string = "[M]";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String saveRomanFive(int n) throws XSLException {
        String string;
        switch (n) {
            case 0: {
                string = "V";
                break;
            }
            case 1: {
                string = "L";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "(V)";
                break;
            }
            case 4: {
                string = "(L)";
                break;
            }
            case 5: {
                string = "(D)";
                break;
            }
            case 6: {
                string = "[V]";
                break;
            }
            case 7: {
                string = "[L]";
                break;
            }
            case 8: {
                string = "[D]";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String saveRomanTen(int n) throws XSLException {
        return XSLNumber.saveRomanOne(n + 1);
    }

    private static int romanToNum(String string) throws XSLException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        if (n2 == 1) {
            return XSLNumber.romanToNumSingle(cArray[0]);
        }
        int n3 = 0;
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            nArray[i] = n = XSLNumber.romanToNumSingle(c);
        }
        Stack<Integer> stack = new Stack<Integer>();
        while (n3 < n2) {
            n = nArray[n3];
            stack.push(new Integer(n));
            if (++n3 == n2) {
                n4 = XSLNumber.terminateStackRoman(stack, n4);
                return n4;
            }
            int n5 = nArray[n3];
            stack.push(new Integer(n5));
            int n6 = Integer.parseInt(stack.pop().toString());
            int n7 = Integer.parseInt(stack.pop().toString());
            if (n6 > n7) {
                n4 += n6 - n7;
                stack.removeAllElements();
            } else {
                stack.push(new Integer(n6));
                n4 += n7;
            }
            if (++n3 != n2) continue;
            n4 = XSLNumber.terminateStackRoman(stack, n4);
            return n4;
        }
        return n4;
    }

    private static int terminateStackRoman(Stack stack, int n) throws XSLException {
        int n2 = stack.size();
        if (n2 == 0) {
            return n;
        }
        if (n2 == 2) {
            int n3;
            int n4 = Integer.parseInt(stack.pop().toString());
            if (n4 > (n3 = Integer.parseInt(stack.pop().toString()))) {
                n += n4 - n3;
            } else {
                n += n3;
                n += n4;
            }
        } else if (n2 == 1) {
            int n5 = Integer.parseInt(stack.pop().toString());
            n += n5;
        } else {
            while (!stack.isEmpty()) {
                int n6 = Integer.parseInt(stack.pop().toString());
                n += n6;
            }
        }
        return n;
    }

    private static int romanToNumSingle(char c) throws XSLException {
        int n = 1;
        switch (c) {
            case 'I': {
                n = 1;
                break;
            }
            case 'V': {
                n = 5;
                break;
            }
            case 'X': {
                n = 10;
                break;
            }
            case 'L': {
                n = 50;
                break;
            }
            case 'C': {
                n = 100;
                break;
            }
            case 'D': {
                n = 500;
                break;
            }
            case 'M': {
                n = 1000;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private String getCountString(int[] nArray, NumberProperties numberProperties) throws XSLException {
        if (nArray == null) {
            return "NaN";
        }
        int n = nArray.length;
        String string = n == 1 ? this.getCountStringSglAny(nArray[0], 0, numberProperties) : this.getCountStringMul(nArray, n, numberProperties);
        string = numberProperties.prefix + string + numberProperties.postfix;
        return string;
    }

    private String getCountStringMul(int[] nArray, int n, NumberProperties numberProperties) throws XSLException {
        String string = "";
        numberProperties.formatsCurPtr = 0;
        int n2 = 0;
        Vector vector = numberProperties.separators;
        if (this.m_blnIsMul && vector != null) {
            n2 = vector.size();
            if (numberProperties.postfix != "") {
                --n2;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                if (i <= n2) {
                    string = string + (String)vector.elementAt(i - 1);
                } else if (n2 < 1) {
                    if (!XMLCompatible.useBuggyBehavior(17626289)) {
                        string = string + ".";
                    }
                } else {
                    string = string + (String)vector.elementAt(n2 - 1);
                }
            }
            string = string + this.getCountStringSglAny(nArray[i], numberProperties.formatsCurPtr, numberProperties);
        }
        return string;
    }

    private String getCountStringSglAny(int n, int n2, NumberProperties numberProperties) throws XSLException {
        Integer n3;
        String string = "";
        int n4 = 0;
        String string2 = "";
        String string3 = "1";
        FastVector fastVector = numberProperties.formats;
        int n5 = fastVector.size();
        DecimalFormat decimalFormat = numberProperties.decimalFormat;
        if (n2 < n5) {
            numberProperties.lastIntCurFor = n3 = (Integer)fastVector.elementAt(n2++);
        } else {
            n3 = numberProperties.lastIntCurFor;
        }
        if (n3 == null) {
            n3 = DEC_FORMAT;
        }
        if (n3.equals(DEC_FORMAT)) {
            decimalFormat.format(0L);
            string2 = decimalFormat.format(n);
            if (n2 < n5) {
                numberProperties.lastPadLen = n4 = ((Integer)fastVector.elementAt(n2++)).intValue();
            } else {
                n4 = numberProperties.lastPadLen;
            }
            if (n4 > 0) {
                decimalFormat.setMinimumIntegerDigits(n4 + 1);
                string2 = decimalFormat.format(n);
            }
            if (n2 < n5) {
                numberProperties.lastFormatStartValue = string3 = fastVector.elementAt(n2++).toString();
            } else if (numberProperties.lastFormatStartValue != null) {
                string3 = numberProperties.lastFormatStartValue;
            }
            if (!string3.equals("1")) {
                int n6 = Integer.valueOf(string3);
                int n7 = Integer.valueOf(string2);
                n7 = n7 + n6 - 1;
                string2 = String.valueOf(n7);
            } else if (this.ordinal) {
                string2 = string2 + this.formatNumberOrdinal(n);
            }
            string = string + string2;
        } else if (n3.equals(ALU_FORMAT)) {
            string2 = decimalFormat.format(n);
            string3 = "";
            if (n2 < n5) {
                string3 = fastVector.elementAt(n2++).toString();
            }
            string = string + XSLNumber.numToAlpha(n);
        } else if (n3.equals(ALL_FORMAT)) {
            string2 = numberProperties.decimalFormat.format(n);
            if (n2 < n5) {
                string3 = fastVector.elementAt(n2++).toString();
            }
            string = string + XSLNumber.numToAlpha(n).toLowerCase();
        } else if (n3.equals(RMU_FORMAT)) {
            string2 = numberProperties.decimalFormat.format(n);
            if (!(string3 = fastVector.elementAt(n2++).toString()).equals("I")) {
                int n8 = XSLNumber.romanToNum(string3);
                int n9 = Integer.valueOf(string2);
                n9 = n9 + n8 - 1;
                string = string + XSLNumber.numToRoman(n9);
            } else {
                string = string + XSLNumber.numToRoman(n);
            }
        } else if (n3.equals(RML_FORMAT)) {
            string2 = numberProperties.decimalFormat.format(n);
            if (!(string3 = fastVector.elementAt(n2++).toString()).equals("i")) {
                string3 = string3.toUpperCase();
                int n10 = XSLNumber.romanToNum(string3);
                int n11 = Integer.valueOf(string2);
                n11 = n11 + n10 - 1;
                string = string + XSLNumber.numToRoman(n11).toLowerCase();
            } else {
                string = string + XSLNumber.numToRoman(n).toLowerCase();
            }
        } else if (n3.equals(NML_FORMAT)) {
            string = string + numberProperties.nformatter.formatNumberName(n, this.ordinal, Boolean.FALSE);
        } else if (n3.equals(NMU_FORMAT)) {
            string = string + numberProperties.nformatter.formatNumberName(n, this.ordinal, Boolean.TRUE);
        } else if (n3.equals(NMT_FORMAT)) {
            string = string + numberProperties.nformatter.formatNumberName(n, this.ordinal, null);
        }
        numberProperties.formatsCurPtr = n2;
        return string;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        Object object2;
        NumberProperties numberProperties = new NumberProperties();
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "number", "", (byte)-1);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, XSLNUMBER);
        }
        XMLError xMLError = xSLTContext.getError();
        if (this.m_stringValue == null && this.select == null && xSLTContext.getContextNode() == null) {
            xMLError.error0(23043, 1);
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        if (this.m_avtLang != null) {
            numberProperties.lang = this.m_avtLang.getValue(xSLTContext);
        }
        this.setDecimalFormat(numberProperties);
        if (this.m_avtGroupingSeparator != null || this.m_avtGroupingSize != null) {
            numberProperties.decimalFormat.setGroupingUsed(true);
        } else {
            numberProperties.decimalFormat.setGroupingUsed(false);
        }
        String string = "1";
        if (this.m_avtFormat != null) {
            string = this.m_avtFormat.getValue(xSLTContext);
        }
        if (this.m_avtLetterValue != null) {
            object2 = this.m_avtLetterValue.getValue(xSLTContext);
            if (object2 != null) {
                object2 = ((String)object2).intern();
            }
            if (object2 != ALPHABETIC && object2 != TRADITIONAL) {
                xMLError.error3(22222, 1, XSLNUMBER, LETTER_VALUE, (String)object2);
            }
            numberProperties.letterValue = object2;
        }
        this.parseFormatString(string, numberProperties);
        if (this.m_avtGroupingSeparator != null) {
            object = this.m_avtGroupingSeparator.getValue(xSLTContext);
            object2 = numberProperties.decimalFormat.getDecimalFormatSymbols();
            ((DecimalFormatSymbols)object2).setGroupingSeparator(((String)object).charAt(0));
            numberProperties.decimalFormat.setDecimalFormatSymbols((DecimalFormatSymbols)object2);
        }
        if (this.m_avtGroupingSize != null) {
            object2 = this.m_avtGroupingSize.getValue(xSLTContext);
            numberProperties.decimalFormat.setGroupingSize(Integer.parseInt((String)object2));
        }
        object2 = null;
        if (this.m_stringValue != null) {
            this.m_stringValue.evaluate(xSLTContext);
            object = (XPathSequence)xSLTContext.popExprValue();
            if (this.isBackwardCompatibilityMode()) {
                double d = XPathSequence.getNumberValue((OXMLSequence)object);
                if (!Double.isNaN(d)) {
                    object2 = new int[1];
                    object2[0] = (int)Math.rint(d);
                }
            } else {
                int n = XPathSequence.getLength((OXMLSequence)object);
                object2 = new int[n];
                int n2 = 0;
                while (((OXMLSequence)object).next()) {
                    OXMLItem oXMLItem = ((OXMLSequence)object).getItem();
                    object2[n2] = (int)Math.rint(XPathItem.getNumberValue(oXMLItem));
                    if (object2[n2] < 0) {
                        xMLError.error1(24009, 1, this.m_stringValue.getExprString());
                    }
                    ++n2;
                }
            }
        } else {
            int n;
            XMLNode xMLNode = null;
            if (this.select != null) {
                this.select.evaluate(xSLTContext);
                object = xSLTContext.popExprValue();
                if (((OXMLSequence)object).next()) {
                    xMLNode = XPathSequence.nextNode((OXMLSequence)object);
                }
                if (xMLNode == null || ((OXMLSequence)object).next()) {
                    xMLError.error0(23042, 1);
                }
                xSLTContext.setContextNode(xMLNode);
            }
            if (this.m_strCount == null) {
                if (xMLNode == null) {
                    xMLNode = xSLTContext.getContextNode();
                }
                n = xMLNode.getNodeType();
                String string2 = "/";
                if (n == 1) {
                    string2 = xMLNode.getNodeName();
                }
                String string3 = xMLNode.getNamespaceURI();
                String string4 = (String)this.prefixHash.get("#xpath-default-namespace");
                this.addNamespace("#xpath-default-namespace", string3);
                this.m_countPattern = XSLExprBase.createPattern(string2, this, false, this.xss);
                this.addNamespace("#xpath-default-namespace", string4);
                this.m_intCountAnchorType = this.m_countPattern.getAnchorType();
                this.m_countPattern.getAnchorName(this.m_countAnchorName);
                this.m_countAnchorNamespace = this.m_countAnchorName[0];
                this.m_countAnchorLocalName = this.m_countAnchorName[1];
            }
            if (this.m_strLevel.equals(MULTIPLE)) {
                object2 = this.getMultiCnt(xSLTContext);
            } else if (this.m_strLevel.equals(ANY)) {
                n = this.getAnyCnt(xSLTContext);
                if (n > 0) {
                    object2 = new int[1];
                    object2[0] = n;
                } else {
                    object2 = new int[0];
                }
            } else {
                n = this.getSingleCnt(xSLTContext);
                if (n > 0) {
                    object2 = new int[1];
                    object2[0] = n;
                } else {
                    object2 = new int[0];
                }
            }
        }
        String string5 = this.getCountString((int[])object2, numberProperties);
        xSLEventHandler.characters(string5, false);
        xSLTContext.instructionCount();
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, XSLNUMBER);
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)-1, xSLTContext.getJDWPContentHandler());
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            block32: {
                string4 = string4.intern();
                if (string3 == VALUE) {
                    this.m_strValue = string4;
                    this.m_stringValue = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
                } else if (string3 == LEVEL) {
                    this.m_strLevel = string4;
                    this.m_blnIsMul = this.m_strLevel.equals(MULTIPLE) || this.m_strLevel.equals(ANY);
                    if (string4 != MULTIPLE && string4 != ANY && string4 != SINGLE) {
                        this.xss.err.error3(22222, 1, XSLNUMBER, LEVEL, string4);
                    }
                } else if (string3 == COUNT) {
                    this.m_strCount = string4;
                    try {
                        this.m_countPattern = XSLExprBase.createPattern(this.m_strCount, this, false, this.xss);
                        this.m_intCountAnchorType = this.m_countPattern.getAnchorType();
                        this.m_countPattern.getAnchorName(this.m_countAnchorName);
                        this.m_countAnchorNamespace = this.m_countAnchorName[0];
                        this.m_countAnchorLocalName = this.m_countAnchorName[1];
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getMessage().contains("current-group()")) {
                            this.xss.err.error0(22277, 1);
                            break block32;
                        }
                        if (xPathException.getMessage().contains("current-grouping-key()")) {
                            this.xss.err.error0(22278, 1);
                            break block32;
                        }
                        String[] stringArray = new String[]{this.m_strCount, string3, this.getQualifiedName(), xPathException.errId == 22026 || xPathException.errId == 1026 || xPathException.errId == 22013 || xPathException.errId == 1013 ? "" : this.xss.err.getMessage1(22242, xPathException.getMessage())};
                        this.xss.err.error(22241, 1, stringArray);
                    }
                } else if (string3 == FROM) {
                    this.m_strFrom = string4;
                    try {
                        this.m_fromPattern = XSLExprBase.createPattern(this.m_strFrom, this, false, this.xss);
                        this.m_intFromAnchorType = this.m_fromPattern.getAnchorType();
                        this.m_fromPattern.getAnchorName(this.m_fromAnchorName);
                        this.m_fromAnchorNamespace = this.m_fromAnchorName[0];
                        this.m_fromAnchorLocalName = this.m_fromAnchorName[1];
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getMessage().contains("current-group()")) {
                            this.xss.err.error0(22277, 1);
                            break block32;
                        }
                        if (xPathException.getMessage().contains("current-grouping-key()")) {
                            this.xss.err.error0(22278, 1);
                            break block32;
                        }
                        String[] stringArray = new String[]{this.m_strFrom, string3, this.getQualifiedName(), xPathException.errId == 22026 || xPathException.errId == 1026 || xPathException.errId == 22013 || xPathException.errId == 1013 ? "" : this.xss.err.getMessage1(22242, xPathException.getMessage())};
                        this.xss.err.error(22241, 1, stringArray);
                    }
                } else if (string3 == LANG) {
                    this.m_avtLang = new XSLNode.AttrValueTmpl(string4, this);
                } else if (string3 == FORMAT) {
                    this.m_avtFormat = new XSLNode.AttrValueTmpl(string4, this);
                } else if (string3 == LETTER_VALUE) {
                    this.m_avtLetterValue = new XSLNode.AttrValueTmpl(string4, this);
                    if (string4 != ALPHABETIC && string4 != TRADITIONAL && !string4.startsWith(LEFT_BRACKET)) {
                        this.xss.err.error3(22222, 1, XSLNUMBER, LETTER_VALUE, string4);
                    }
                } else if (string3 == GROUPING_SEPARATOR) {
                    this.m_avtGroupingSeparator = new XSLNode.AttrValueTmpl(string4, this);
                } else if (string3 == GROUPING_SIZE) {
                    this.m_avtGroupingSize = new XSLNode.AttrValueTmpl(string4, this);
                } else if (string3 == "select") {
                    this.select = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
                } else if (string3 == ORDINAL && !string4.equals("")) {
                    this.ordinal = true;
                }
            }
            super.setAttribute(string, string2, string3, string4);
        }
    }

    private void setDecimalFormat(NumberProperties numberProperties) {
        Locale locale = null;
        String string = numberProperties.lang;
        if (string != null && string.length() == 5 && string.indexOf(95) == 2) {
            String string2 = string.substring(0, 2).toLowerCase();
            String string3 = string.substring(3).toUpperCase();
            locale = new Locale(string2, string3);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.getLanguage().equals("en")) {
            this.ordinal = false;
        }
        numberProperties.decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        char c = decimalFormatSymbols.getGroupingSeparator();
        if (c > '\u007f') {
            decimalFormatSymbols.setGroupingSeparator('.');
        }
        numberProperties.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    XSLExprBase matchFromPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        if (this.m_intFromAnchorType != -1) {
            if (this.m_intFromAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.m_fromAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? !this.m_fromAnchorLocalName.equals(((XMLNSNode)(object = (XMLElement)xMLNode)).getNodeLocalName()) || !this.m_fromAnchorNamespace.equals(((XMLElement)object).getNamespace()) : (xMLNode.getNodeType() == 2 ? !this.m_fromAnchorLocalName.equals(((XMLNSNode)(object = (XMLAttr)xMLNode)).getNodeLocalName()) || !this.m_fromAnchorNamespace.equals(((XMLAttr)object).getNamespace()) : !xMLNode.getNodeName().equals(this.m_fromAnchorLocalName)))) {
                return null;
            }
        }
        xSLTContext.saveCapturedSubstring(false);
        object = this.m_fromPattern.matchPattern(xMLNode, f, xSLTContext);
        xSLTContext.restoreCapturedSubstring();
        return object;
    }

    private String formatNumberOrdinal(long l) {
        long l2 = l % 10L;
        long l3 = l % 100L;
        if (l2 == 1L && l3 != 11L) {
            return "st";
        }
        if (l2 == 2L && l3 != 12L) {
            return "nd";
        }
        if (l2 == 3L && l3 != 13L) {
            return "rd";
        }
        return "th";
    }

    XSLExprBase matchCountPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        if (this.m_intCountAnchorType != -1) {
            if (this.m_intCountAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.m_countAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? !this.m_countAnchorLocalName.equals(((XMLNSNode)(object = (XMLElement)xMLNode)).getNodeLocalName()) || !this.m_countAnchorNamespace.equals(((XMLElement)object).getNamespace()) : (xMLNode.getNodeType() == 2 ? !this.m_countAnchorLocalName.equals(((XMLNSNode)(object = (XMLAttr)xMLNode)).getNodeLocalName()) || !this.m_countAnchorNamespace.equals(((XMLAttr)object).getNamespace()) : !xMLNode.getNodeName().equals(this.m_countAnchorLocalName)))) {
                return null;
            }
        }
        xSLTContext.saveCapturedSubstring(false);
        object = this.m_countPattern.matchPattern(xMLNode, f, xSLTContext);
        xSLTContext.restoreCapturedSubstring();
        return object;
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        if (this.m_strValue != null && (this.select != null || this.m_strLevel != null || this.m_strCount != null || this.m_strFrom != null)) {
            this.xss.err.error0(22273, 1);
        }
        if (this.m_strLevel == null) {
            this.m_strLevel = SINGLE;
        }
    }

    public static class NumberProperties {
        Integer lastIntCurFor;
        String lastFormatStartValue;
        int lastPadLen;
        String lang = null;
        DecimalFormat decimalFormat;
        String letterValue = "traditional";
        IntFormatter nformatter = new IntFormatter();
        int formatsCurPtr = 0;
        String prefix = "";
        String postfix = "";
        Vector separators;
        FastVector formats;
    }

    static class IntFormatter
    extends IntegerFormatter<XSLException> {
        @Override
        public XSLException createInvalidPictureStringException(String string) {
            return null;
        }

        @Override
        public XSLException notSupported(String string) {
            return null;
        }

        String formatNumberName(int n, boolean bl, Boolean bl2) throws XSLException {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                this.formatNumberName(n, bl, bl2, stringBuilder);
            }
            catch (Exception exception) {
                throw new XSLException(exception.getMessage());
            }
            return stringBuilder.toString();
        }
    }
}

