/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

public class XPathSeqType
implements XSLExprConstants {
    static OXMLSequenceType parse(XSLParseString xSLParseString) throws XSLException {
        int n;
        OXMLSequenceType oXMLSequenceType = null;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(241, 0);
        }
        if ((n = xSLParseString.nextToken()) == 116) {
            oXMLSequenceType = OXMLSequenceType.EMPTY_SEQUENCE;
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(242, 2);
            }
        } else if (n == 114 && xSLParseString.getItemType() == 710) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(214, 0);
            }
            if (xSLParseString.peekToken(115)) {
                switch (XPathSeqType.mapOccurIndicator(xSLParseString.getOccurIndicator())) {
                    case 1: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ONE;
                        break;
                    }
                    case 4: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ZERO_OR_MORE;
                        break;
                    }
                    case 2: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ZERO_OR_ONE;
                        break;
                    }
                    case 3: {
                        oXMLSequenceType = OXMLSequenceType.ITEM_ONE_OR_MORE;
                    }
                }
            } else {
                oXMLSequenceType = OXMLSequenceType.ITEM_ONE;
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(214, 1);
            }
        } else if (n == 114 && xSLParseString.getItemType() == 711) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(215, 0);
            }
            QxName qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            if (xSLParseString.peekToken(115)) {
                int n2 = xSLParseString.getOccurIndicator();
                oXMLSequenceType = OXMLSequenceType.createValueType(qxName, XPathSeqType.mapOccurIndicator(n2), xSLParseString.getXMLSchema());
                if (xPathCompileEvents != null && n2 == 722) {
                    xPathCompileEvents.reportEventsWithStringParam(240, 1, xSLParseString.getNamespace(), xSLParseString.getLocalName(), null);
                }
            } else {
                oXMLSequenceType = OXMLSequenceType.createValueType(qxName, 1, xSLParseString.getXMLSchema());
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(215, 1);
            }
        } else if (n == 117) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(213, 0);
            }
            switch (xSLParseString.getKindTest()) {
                case 404: {
                    oXMLSequenceType = XPathSeqType.parseDocTest(xSLParseString, oXMLSequenceType);
                    break;
                }
                case 405: {
                    oXMLSequenceType = XPathSeqType.parseElementTest(xSLParseString, 1);
                    break;
                }
                case 406: {
                    oXMLSequenceType = XPathSeqType.parseAttrTest(xSLParseString);
                    break;
                }
                case 407: {
                    oXMLSequenceType = XPathSeqType.parseSchemaElementTest(xSLParseString, 1);
                    break;
                }
                case 408: {
                    oXMLSequenceType = XPathSeqType.parseSchemaAttrTest(xSLParseString);
                    break;
                }
                case 400: {
                    oXMLSequenceType = XPathSeqType.parsePITest(xSLParseString);
                    break;
                }
                case 401: {
                    oXMLSequenceType = XPathSeqType.parseCommentTest(xSLParseString);
                    break;
                }
                case 402: {
                    oXMLSequenceType = XPathSeqType.parseTextTest(xSLParseString);
                    break;
                }
                case 403: {
                    oXMLSequenceType = XPathSeqType.parseAnyKindTest(xSLParseString);
                }
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(213, 1);
            }
        } else if (n == 110) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(213, 0);
            }
            switch (xSLParseString.getNodeTest()) {
                case 404: {
                    oXMLSequenceType = XPathSeqType.parseDocTest(xSLParseString, oXMLSequenceType);
                    break;
                }
                case 405: {
                    oXMLSequenceType = XPathSeqType.parseElementTest(xSLParseString, 1);
                    break;
                }
                case 406: {
                    oXMLSequenceType = XPathSeqType.parseAttrTest(xSLParseString);
                    break;
                }
                case 407: {
                    oXMLSequenceType = XPathSeqType.parseSchemaElementTest(xSLParseString, 1);
                    break;
                }
                case 408: {
                    oXMLSequenceType = XPathSeqType.parseSchemaAttrTest(xSLParseString);
                    break;
                }
                case 400: {
                    oXMLSequenceType = XPathSeqType.parsePITest(xSLParseString);
                    break;
                }
                case 401: {
                    oXMLSequenceType = XPathSeqType.parseCommentTest(xSLParseString);
                    break;
                }
                case 402: {
                    oXMLSequenceType = XPathSeqType.parseTextTest(xSLParseString);
                    break;
                }
                case 403: {
                    oXMLSequenceType = XPathSeqType.parseAnyKindTest(xSLParseString);
                }
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(213, 1);
            }
        }
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(241, 1);
        }
        return oXMLSequenceType;
    }

    public static OXMLSequenceType createSequenceType(String string, NSResolver nSResolver, XSLStylesheet xSLStylesheet) throws XSLException, XQException {
        Object object;
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, xSLStylesheet);
        xSLParseString.setInitState(4);
        if (nSResolver instanceof XSLNode) {
            object = (XSLNode)nSResolver;
            xSLParseString.setCompatibilityFlags(((XSLNode)object).getXSLTVersion(), ((XSLNode)object).isBackwardCompatibilityMode(), ((XSLNode)object).isForwardCompatibilityMode());
        }
        object = XPathSeqType.parse(xSLParseString);
        return object;
    }

    private static OXMLSequenceType parseDocTest(XSLParseString xSLParseString, OXMLSequenceType oXMLSequenceType) throws XPathException {
        int n;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(204, 0);
        }
        if (xSLParseString.peekToken(117)) {
            n = xSLParseString.getKindTest();
            if (n == 405) {
                oXMLSequenceType = XPathSeqType.parseElementTest(xSLParseString, 9);
            } else if (n == 407) {
                oXMLSequenceType = XPathSeqType.parseSchemaElementTest(xSLParseString, 9);
            } else {
                throw new XPathException(1013, "document-node");
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "document-node");
        }
        n = XPathSeqType.nextOccurIndicator(xSLParseString);
        if (oXMLSequenceType == null) {
            oXMLSequenceType = OXMLSequenceType.createNodeType(9, n);
        } else {
            oXMLSequenceType.setOccurence(n);
        }
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(204, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseElementTest(XSLParseString xSLParseString, int n) throws XPathException {
        int n2;
        QxName qxName = null;
        QxName qxName2 = null;
        int n3 = 0;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(208, 0);
        }
        if ((n2 = xSLParseString.peekToken()) == 120 || n2 == 119) {
            xSLParseString.nextToken();
            if (n2 == 120) {
                qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            }
            if (xSLParseString.peekToken(1)) {
                if (xSLParseString.nextToken() != 120) {
                    throw new XPathException(1013, "element");
                }
                qxName2 = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
                if (xSLParseString.peekToken(115)) {
                    if (xSLParseString.getOccurIndicator() == 722) {
                        n3 = -1;
                    } else {
                        throw new XPathException(1013, "element");
                    }
                }
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "element");
        }
        int n4 = 1;
        if (n == 1) {
            n4 = XPathSeqType.nextOccurIndicator(xSLParseString);
        }
        XMLSchema xMLSchema = xSLParseString.getXMLSchema();
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)qxName, (QName)qxName2, n, n3 != 0, n4, xMLSchema);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(208, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseAttrTest(XSLParseString xSLParseString) throws XPathException {
        int n;
        QxName qxName = null;
        QxName qxName2 = null;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(206, 0);
        }
        if ((n = xSLParseString.peekToken()) == 120 || n == 119) {
            xSLParseString.nextToken();
            if (n == 120) {
                qxName = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
            }
            if (xSLParseString.peekToken(1)) {
                if (xSLParseString.nextToken() == 120) {
                    qxName2 = new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName());
                } else {
                    throw new XPathException(1013, "attribute");
                }
            }
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "attribute");
        }
        int n2 = XPathSeqType.nextOccurIndicator(xSLParseString);
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)qxName, qxName2, 2, false, n2, xSLParseString.getXMLSchema());
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(206, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseSchemaElementTest(XSLParseString xSLParseString, int n) throws XPathException {
        QxName qxName = null;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(211, 0);
        }
        if (xSLParseString.nextToken() != 120) {
            throw new XPathException(1013, "schema-element");
        }
        qxName = QxNameHash.create(xSLParseString.getNamespace(), xSLParseString.getLocalName());
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "schema-element");
        }
        int n2 = 1;
        n2 = XPathSeqType.nextOccurIndicator(xSLParseString);
        XMLSchema xMLSchema = xSLParseString.getXMLSchema();
        XSDElement xSDElement = null;
        if (xMLSchema != null) {
            xSDElement = xMLSchema.getElement(qxName.getNamespaceURI(), qxName.getLocalPart());
        }
        if (xSDElement == null) {
            throw new XPathException(23048, "schema-element");
        }
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)qxName, null, n, false, n2, xMLSchema);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(211, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseSchemaAttrTest(XSLParseString xSLParseString) throws XPathException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(210, 0);
        }
        if (xSLParseString.nextToken() != 120) {
            throw new XPathException(1013, "schema-attribute");
        }
        String string = xSLParseString.getNamespace();
        String string2 = xSLParseString.getLocalName();
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "schema-attribute");
        }
        int n = 1;
        n = XPathSeqType.nextOccurIndicator(xSLParseString);
        XMLSchema xMLSchema = xSLParseString.getXMLSchema();
        XSDAttribute xSDAttribute = null;
        if (xMLSchema != null) {
            xSDAttribute = xMLSchema.getAttribute(string, string2);
        }
        if (xSDAttribute == null) {
            throw new XPathException(23048, "schema-attribute");
        }
        QxName qxName = QxNameHash.create(string, string2);
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)qxName, null, 2, false, 1, xMLSchema);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(210, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parsePITest(XSLParseString xSLParseString) throws XPathException {
        String string = null;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(209, 0);
        }
        if (xSLParseString.peekToken(118)) {
            string = xSLParseString.getNCName();
        } else if (xSLParseString.peekToken(109)) {
            if (xSLParseString.getLiteralType() != 303) {
                throw new XPathException(1013, "processing-instruction");
            }
            string = xSLParseString.getLiteralValue();
        }
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "processing-instruction");
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        if (string == null) {
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(7, n);
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(209, 1);
            }
            return oXMLSequenceType;
        }
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(new QxName("", string), null, 7, false, n);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(209, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseCommentTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "comment");
        }
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(207, 0);
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(8, n);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(207, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseTextTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "text");
        }
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(212, 0);
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(3, n);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(212, 1);
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType parseAnyKindTest(XSLParseString xSLParseString) throws XPathException {
        if (xSLParseString.nextToken() != 26) {
            throw new XPathException(1013, "node");
        }
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(205, 0);
        }
        int n = XPathSeqType.nextOccurIndicator(xSLParseString);
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(n);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(205, 1);
        }
        return oXMLSequenceType;
    }

    private static int nextOccurIndicator(XSLParseString xSLParseString) throws XPathException {
        int n = xSLParseString.peekToken(115) ? XPathSeqType.mapOccurIndicator(xSLParseString.getOccurIndicator()) : 1;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsWithIntParam(216, 2, n, 0);
        }
        return n;
    }

    private static int mapOccurIndicator(int n) {
        switch (n) {
            case 722: {
                return 2;
            }
            case 720: {
                return 4;
            }
            case 721: {
                return 3;
            }
        }
        return -1;
    }

    static String getNormalizedExpr(OXMLSequenceType oXMLSequenceType) throws XQException {
        return "";
    }
}

