/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.LongArrayIndex;

class IntArrayIndex
extends BinaryIndex {
    int[][] index = new int[64][];
    int[][] children = new int[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final int EMPTY_FLAG = Integer.MIN_VALUE;

    IntArrayIndex() {
    }

    @Override
    public BinaryIndex enlargeIndex() {
        LongArrayIndex longArrayIndex = new LongArrayIndex();
        longArrayIndex.depth = this.depth;
        longArrayIndex.level = this.level;
        for (int i = 0; i < this.depth; ++i) {
            int[] nArray = this.index[i];
            int[] nArray2 = this.children[i];
            int n = nArray.length;
            long[] lArray = new long[n * 2];
            int[] nArray3 = new int[n * 2];
            for (int j = 0; j < n; ++j) {
                lArray[j] = nArray[j];
                nArray3[j] = nArray2[j];
            }
            longArrayIndex.index[i] = lArray;
            longArrayIndex.children[i] = nArray3;
        }
        System.arraycopy(this.child, 0, longArrayIndex.child, 0, 64);
        System.arraycopy(this.length, 0, longArrayIndex.length, 0, 64);
        return longArrayIndex;
    }

    @Override
    public boolean startElement(long l) {
        if (l >= Integer.MAX_VALUE) {
            return false;
        }
        this.write(l, this.level, false);
        this.child[this.level] = false;
        if (this.level > 0 && !this.child[this.level - 1]) {
            int n = this.length[this.level];
            this.write(n, this.level - 1, true);
            this.child[this.level - 1] = true;
        }
        int n = this.level++;
        this.length[n] = this.length[n] + 1;
        return true;
    }

    @Override
    public void endElement() {
        int n = this.length[this.level] | Integer.MIN_VALUE;
        if (n == 0) {
            n = -1;
        }
        --this.level;
        if (this.level >= 0 && !this.child[this.level]) {
            this.write(n, this.level, true);
            this.child[this.level] = true;
        }
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        this.level = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new int[1];
        this.children[0] = new int[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n = infosetReader.getEventType();
            switch (n) {
                case 1: {
                    int n2;
                    this.write(infosetReader.offsetToLong(), this.level, false);
                    this.child[this.level] = false;
                    if (this.level > 0 && !this.child[this.level - 1]) {
                        n2 = this.length[this.level];
                        this.write(n2, this.level - 1, true);
                        this.child[this.level - 1] = true;
                    }
                    int n3 = this.level++;
                    this.length[n3] = this.length[n3] + 1;
                    break;
                }
                case 2: {
                    int n2 = this.length[this.level] | Integer.MIN_VALUE;
                    if (n2 == 0) {
                        n2 = -1;
                    }
                    --this.level;
                    if (this.level < 0 || this.child[this.level]) break;
                    this.write(n2, this.level, true);
                    this.child[this.level] = true;
                    break;
                }
            }
        }
        long l = 0L;
        for (int i = 1; i < 64; ++i) {
            int[] nArray;
            int[] nArray2 = this.index[i];
            if (nArray2 == null) {
                this.depth = i;
                break;
            }
            int n = this.length[i];
            l += (long)this.length[i];
            if (nArray2.length - n > 1024) {
                nArray = new int[n];
                System.arraycopy(nArray2, 0, nArray, 0, n);
                this.index[i] = nArray;
            }
            if ((nArray2 = this.children[i]) == null || nArray2.length - n <= 1024) continue;
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
            this.children[i] = nArray;
        }
    }

    private void write(long l, int n, boolean bl) {
        int[][] nArray = bl ? this.children : this.index;
        int[] nArray2 = nArray[n];
        if (nArray2 == null) {
            nArray2 = n == 0 ? new int[1] : new int[1024];
            nArray[n] = nArray2;
            if (!bl) {
                ++this.depth;
            }
        }
        int n2 = this.length[n];
        if (bl) {
            --n2;
        }
        if (n2 >= nArray2.length) {
            int[] nArray3 = nArray2;
            nArray2 = new int[n2 * 2];
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            nArray[n] = nArray2;
        }
        nArray2[n2] = (int)l;
    }

    public long getIndex(long l) {
        int[] nArray;
        int n = (int)l;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.depth && n < (nArray = this.index[i])[n3]; ++i) {
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                int n5 = n - nArray[n4];
                if (n5 == 0) {
                    return (long)i << 32 | (long)n3;
                }
                if (n5 > 0) {
                    n2 = n2 == n4 ? n3 : n4;
                    continue;
                }
                n3 = n4;
            }
            if (n == nArray[n3]) {
                return (long)i << 32 | (long)n3;
            }
            n2 = this.children[i][n3];
            n3 = this.getChildEnd(i, n3);
        }
        return -1L;
    }

    @Override
    long getLocator(int n, int n2) {
        return this.index[n][n2];
    }

    @Override
    int getChildStart(int n, int n2) {
        int n3 = this.children[n][n2];
        if (n3 < 0) {
            return -1;
        }
        return n3 & 0xFFFFFFFF;
    }

    @Override
    int getChildEnd(int n, int n2) {
        if (++n2 >= this.length[n]) {
            return this.length[n + 1];
        }
        int n3 = this.children[n][n2] & Integer.MAX_VALUE;
        return n3;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

