/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.util.Arrays;
import java.util.List;
import oracle.jdbc.driver.cli.AbstractCommand;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.Option;
import oracle.jdbc.driver.cli.TcpFastOpenLibraryInstaller;
import oracle.jdbc.driver.cli.ValuedOption;

class InstallTcpFastOpenLibCommand
extends AbstractCommand {
    InstallTcpFastOpenLibCommand() {
    }

    @Override
    public String getName() {
        return "install-tfo";
    }

    @Override
    public String getShortUsage() {
        return "Install the TFO library";
    }

    @Override
    public String getLongUsage() {
        return "Installs TCP Fast Open native library in the installation path.";
    }

    @Override
    public List<Option> getExpectedOptions() {
        ValuedOption path = new ValuedOption("path", "p", "Installation-path", "Installation path", true, 1, null);
        Option help = new Option("help", "h", "Show help message", false, 1);
        return Arrays.asList(path, help);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.hasOption("help")) {
            this.printCommandHelp(context.getCommandPrefix());
            return;
        }
        try {
            String path = context.getOptionValues("path").get(0);
            TcpFastOpenLibraryInstaller.install(path);
        }
        catch (Exception e) {
            System.err.println("Error during installation: " + e.getMessage());
        }
    }
}

