/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonParsingException;

public abstract class OracleJsonExceptions {
    public static final ExceptionFactory ORACLE_FACTORY = new OracleExceptionFactory();
    public static final OracleJsonExceptions IO = OracleJsonExceptions.jzn("001");
    public static final OracleJsonExceptions BAD_YEAR = OracleJsonExceptions.jzn("002");
    public static final OracleJsonExceptions NOT_IMPLEMENTED = OracleJsonExceptions.jzn("004");
    public static final OracleJsonExceptions CORRUPT = OracleJsonExceptions.jzn("005");
    public static final OracleJsonExceptions UNSUPPORTED_VERSION = OracleJsonExceptions.jzn("006");
    public static final OracleJsonExceptions LONG_KEY = OracleJsonExceptions.jzn("007");
    public static final OracleJsonExceptions IMAGE_TOO_BIG = OracleJsonExceptions.jzn("008");
    public static final OracleJsonExceptions CORRUPT2 = OracleJsonExceptions.jzn("009");
    public static final OracleJsonExceptions NO_DAYS_ALLOWED = OracleJsonExceptions.jzn("010");
    public static final OracleJsonExceptions BAD_WRAP = OracleJsonExceptions.jzn("020");
    public static final OracleJsonExceptions PARSER_ENC_DETECT_FAIL = OracleJsonExceptions.jzn("024");
    public static final OracleJsonExceptions BAD_TIMESTAMP_TZ = OracleJsonExceptions.jzn("036");
    public static final OracleJsonExceptions GENERATION_INCOMPLETE = OracleJsonExceptions.gen("011");
    public static final OracleJsonExceptions MISSING_KEY = OracleJsonExceptions.gen("012");
    public static final OracleJsonExceptions EXTRA_EVENTS = OracleJsonExceptions.gen("013");
    public static final OracleJsonExceptions BAD_END = OracleJsonExceptions.gen("014");
    public static final OracleJsonExceptions BAD_KEY = OracleJsonExceptions.gen("015");
    public static final OracleJsonExceptions EXPECTED_VALUE = OracleJsonExceptions.gen("016");
    public static final OracleJsonExceptions DUPLICATE_KEY = OracleJsonExceptions.gen("023");
    public static final OracleJsonExceptions PARSER_EXPECTED_EOF = OracleJsonExceptions.par("025");
    public static final OracleJsonExceptions TOKEN_UNEXPECTED_CHAR = OracleJsonExceptions.par("026");
    public static final OracleJsonExceptions TOKEN_EXPECTED_CHAR = OracleJsonExceptions.par("027");
    public static final OracleJsonExceptions PARSER_INVALID_TOKEN = OracleJsonExceptions.par("028");
    public static final OracleJsonExceptions OVERFLOW = OracleJsonExceptions.ill("003");
    public static final OracleJsonExceptions BAD_PARSER_STATE = OracleJsonExceptions.ill("017");
    public static final OracleJsonExceptions BAD_PARSER_STATE3 = OracleJsonExceptions.ill("018");
    public static final OracleJsonExceptions BAD_PARSER_STATE_VALUE = OracleJsonExceptions.ill("019");
    public static final OracleJsonExceptions PARSER_GETSTRING_ERR = OracleJsonExceptions.ill("029");
    public static final OracleJsonExceptions PARSER_ISINTEGRAL_ERR = OracleJsonExceptions.ill("030");
    public static final OracleJsonExceptions PARSER_GETINT_ERR = OracleJsonExceptions.ill("031");
    public static final OracleJsonExceptions PARSER_GETLONG_ERR = OracleJsonExceptions.ill("032");
    public static final OracleJsonExceptions PARSER_GETBIGDECIMAL_ERR = OracleJsonExceptions.ill("033");
    public static final OracleJsonExceptions PARSER_GETARRAY_ERR = OracleJsonExceptions.ill("034");
    public static final OracleJsonExceptions PARSER_GETOBJECT_ERR = OracleJsonExceptions.ill("035");
    public static final OracleJsonExceptions OBJ_NOT_MUTABLE = OracleJsonExceptions.uso("021");
    public static final OracleJsonExceptions ARR_NOT_MUTABLE = OracleJsonExceptions.uso("022");
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("oracle.jdbc.driver.Messages");
    private String key;

    private OracleJsonExceptions(String string) {
        this.key = string;
    }

    public abstract RuntimeException create(ExceptionFactory var1, Throwable var2, Object ... var3);

    public abstract RuntimeException create(ExceptionFactory var1, Object ... var2);

    public String getMessage(Object ... objectArray) {
        return MessageFormat.format(MESSAGES.getString("JSON-" + this.key), objectArray);
    }

    private static OracleJsonExceptions jzn(String string) {
        return new OracleJsonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray));
            }
        };
    }

    private static OracleJsonExceptions par(String string) {
        return new OracleJsonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray));
            }
        };
    }

    private static OracleJsonExceptions gen(String string) {
        return new OracleJsonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createGenerationException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createGenerationException(this.getMessage(objectArray));
            }
        };
    }

    private static OracleJsonExceptions ill(String string) {
        return new OracleJsonExceptions(string){

            @Override
            public IllegalStateException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return new IllegalStateException(this.getMessage(objectArray), throwable);
            }

            @Override
            public IllegalStateException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return new IllegalStateException(this.getMessage(objectArray));
            }
        };
    }

    private static OracleJsonExceptions uso(String string) {
        return new OracleJsonExceptions(string){

            @Override
            public UnsupportedOperationException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return new UnsupportedOperationException(this.getMessage(objectArray), throwable);
            }

            @Override
            public UnsupportedOperationException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return new UnsupportedOperationException(this.getMessage(objectArray));
            }
        };
    }

    private static final class OracleExceptionFactory
    implements ExceptionFactory {
        private OracleExceptionFactory() {
        }

        @Override
        public RuntimeException createJsonException(String string, Throwable throwable) {
            return new OracleJsonException(string, throwable);
        }

        @Override
        public RuntimeException createJsonException(String string) {
            return new OracleJsonException(string);
        }

        @Override
        public RuntimeException createGenerationException(String string, Throwable throwable) {
            return new OracleJsonGenerationException(string, throwable);
        }

        @Override
        public RuntimeException createGenerationException(String string) {
            return new OracleJsonGenerationException(string);
        }

        @Override
        public RuntimeException createParsingException(String string) {
            return new OracleJsonParsingException(string);
        }

        @Override
        public RuntimeException createParsingException(String string, Throwable throwable) {
            return new OracleJsonParsingException(string, throwable);
        }
    }

    public static interface ExceptionFactory {
        public RuntimeException createJsonException(String var1, Throwable var2);

        public RuntimeException createJsonException(String var1);

        public RuntimeException createGenerationException(String var1);

        public RuntimeException createGenerationException(String var1, Throwable var2);

        public RuntimeException createParsingException(String var1);

        public RuntimeException createParsingException(String var1, Throwable var2);
    }
}

