/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.util.OracleConfigurationCache;

public class OracleConfigurationHttpsProvider
extends OracleConfigurationParsableProvider {
    private static final String CLASS_NAME = OracleConfigurationHttpsProvider.class.getName();
    private static final String HTTPS_RETRY_COUNT_KEY = "https_retry_count";
    private static final String HTTPS_RETRY_DELAY_KEY = "https_retry_delay";
    private static final String HTTPS_CONNECTION_TIMEOUT_KEY = "https_connection_timeout";
    private static final OracleConfigurationCache CACHE = OracleConfigurationCache.create(100);

    @Override
    public OracleConfigurationCache getCache() {
        return CACHE;
    }

    @Override
    public InputStream getInputStream(String location) throws SQLException {
        String authorizationHeader = null;
        if (this.options.containsKey("authentication") && ((String)this.options.get("authentication")).equals("basic")) {
            String headerValue = Base64.getEncoder().encodeToString(((String)this.options.get("user") + ":" + (String)this.options.get("password")).getBytes());
            authorizationHeader = "Basic " + headerValue;
        }
        int httpsRetryCount = this.parseConfig(HTTPS_RETRY_COUNT_KEY, 0, 0);
        int httpsRetryDelay = this.parseConfig(HTTPS_RETRY_DELAY_KEY, 1, 1);
        int httpsConnectionTimeout = this.parseConfig(HTTPS_CONNECTION_TIMEOUT_KEY, 20, 0);
        String urlWithoutRetries = this.options.containsKey(HTTPS_RETRY_COUNT_KEY) || this.options.containsKey(HTTPS_RETRY_DELAY_KEY) || this.options.containsKey(HTTPS_CONNECTION_TIMEOUT_KEY) ? this.removeCustomParam(location) : location;
        IOException lastException = null;
        for (int i = 0; i <= httpsRetryCount; ++i) {
            try {
                HttpURLConnection connection = this.getHttpURLConnection(urlWithoutRetries);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "application/json");
                connection.setConnectTimeout(httpsConnectionTimeout * 1000);
                if (authorizationHeader != null) {
                    connection.setRequestProperty("Authorization", authorizationHeader);
                }
                connection.setDoOutput(true);
                return connection.getInputStream();
            }
            catch (IOException ex) {
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "getInputStream", "Request failed, attempt number: " + i + "1", null, ex);
                if (i == httpsRetryCount) {
                    lastException = ex;
                    break;
                }
                try {
                    Thread.sleep((long)httpsRetryDelay * 1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new SQLException("Thread was interrupted during https retry delay", ie);
                }
            }
        }
        throw new SQLException("Error retrieving configuration", lastException);
    }

    @Override
    public String getType() {
        return "https";
    }

    HttpURLConnection getHttpURLConnection(String location) throws IOException {
        if (!((String)location).startsWith("https://")) {
            location = "https://" + (String)location;
        }
        URL url = new URL((String)location);
        return (HttpsURLConnection)url.openConnection();
    }

    private String removeCustomParam(String location) {
        String[] params = location.split("\\?");
        String baseUrl = params[0];
        StringBuilder paramsBuilder = new StringBuilder();
        for (Map.Entry entry : this.options.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (HTTPS_RETRY_COUNT_KEY.equals(key) || HTTPS_RETRY_DELAY_KEY.equals(key) || HTTPS_CONNECTION_TIMEOUT_KEY.equals(key)) continue;
            if (paramsBuilder.length() > 0) {
                paramsBuilder.append("&");
            }
            paramsBuilder.append(key).append("=").append(value);
        }
        return paramsBuilder.length() > 0 ? baseUrl + "?" + paramsBuilder : baseUrl;
    }

    private int parseConfig(String key, int defaultValue, int minValue) {
        int value = Integer.parseInt(this.options.getOrDefault(key, String.valueOf(defaultValue)));
        if (value < minValue) {
            throw new IllegalArgumentException("Invalid configurations:" + key + " = " + value + ". Must be >= " + minValue);
        }
        return value;
    }
}

