/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.util.Objects;
import oracle.jdbc.TraceKey;
import oracle.jdbc.diagnostics.ImmutableTraceAttributes;
import oracle.jdbc.diagnostics.OracleTraceKey;
import oracle.jdbc.diagnostics.TraceAttributes;

public class MutableTraceAttributes
extends TraceAttributes {
    private ImmutableTraceAttributes cachedImmutableCopy = null;
    private ImmutableTraceAttributes otherCachedImmutableCopy = null;

    public MutableTraceAttributes() {
    }

    public MutableTraceAttributes(ImmutableTraceAttributes immutableTraceAttributes) {
        super(immutableTraceAttributes.values);
    }

    public void set(TraceKey key, String value) {
        if (key == null) {
            return;
        }
        if (!Objects.equals(this.values[key.index()], value)) {
            if (key == OracleTraceKey.SQL) {
                if (this.values[key.index()] != null && value == null) {
                    this.swapCachedAttributes();
                } else if (this.values[key.index()] != null && value != null) {
                    this.cachedImmutableCopy = null;
                } else if (this.values[key.index()] == null && value != null) {
                    this.swapCachedAttributes();
                    if (this.cachedImmutableCopy != null && this.cachedImmutableCopy.values[key.index()] != null && !this.cachedImmutableCopy.values[key.index()].equals(value)) {
                        this.cachedImmutableCopy = null;
                    }
                }
                this.values[key.index()] = value;
            } else {
                this.values[key.index()] = value;
                this.cachedImmutableCopy = null;
                this.otherCachedImmutableCopy = null;
            }
        }
    }

    private void swapCachedAttributes() {
        ImmutableTraceAttributes temp = this.cachedImmutableCopy;
        this.cachedImmutableCopy = this.otherCachedImmutableCopy;
        this.otherCachedImmutableCopy = temp;
    }

    @Override
    public ImmutableTraceAttributes toReadOnly() {
        if (this.cachedImmutableCopy == null) {
            this.cachedImmutableCopy = new ImmutableTraceAttributes(this.values);
        }
        return this.cachedImmutableCopy;
    }

    public ImmutableTraceAttributes toReadOnlyWithoutKey(OracleTraceKey key) {
        this.set(key, null);
        return this.toReadOnly();
    }
}

