/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCacheKey;

public class DownHostsCache {
    private static final DownHostsCache SOLE_INSTANCE = new DownHostsCache();
    static int DOWN_HOSTS_TIMEOUT = Integer.parseInt("600");
    private static final int MIN_TIME_BETWEEN_PURGES = 60;
    private Map<DownHostsCacheKey, LocalDateTime> downHostsCacheMap = new ConcurrentHashMap<DownHostsCacheKey, LocalDateTime>();
    private LocalDateTime lastPurge = LocalDateTime.MIN;

    private DownHostsCache() {
    }

    public static DownHostsCache getInstance() {
        return SOLE_INSTANCE;
    }

    LocalDateTime markDownHost(InetAddress inetAddress, int port) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(inetAddress.getHostAddress(), port), LocalDateTime.now());
    }

    public void reorderAddresses(InetAddress[] inetAddress, int port) {
        this.refreshCache();
        int topListIndex = 0;
        int bottomListIndex = inetAddress.length - 1;
        while (topListIndex < bottomListIndex) {
            while (topListIndex <= bottomListIndex && !this.isDownHostsCached(inetAddress[topListIndex], port)) {
                ++topListIndex;
            }
            while (bottomListIndex >= topListIndex && this.isDownHostsCached(inetAddress[bottomListIndex], port)) {
                --bottomListIndex;
            }
            if (topListIndex >= bottomListIndex) continue;
            DownHostsCache.swap(inetAddress, topListIndex, bottomListIndex);
        }
    }

    private static <T> void swap(T[] array, int indexLow, int indexHigh) {
        T swapped = array[indexLow];
        array[indexLow] = array[indexHigh];
        array[indexHigh] = swapped;
    }

    private void refreshCache() {
        if (LocalDateTime.now().minus(60L, ChronoUnit.SECONDS).isAfter(this.lastPurge)) {
            for (DownHostsCacheKey downHostsCacheKey : this.downHostsCacheMap.keySet()) {
                LocalDateTime entryTime = this.downHostsCacheMap.get(downHostsCacheKey);
                if (entryTime == null || LocalDateTime.now().minus(DOWN_HOSTS_TIMEOUT, ChronoUnit.SECONDS).compareTo(entryTime) <= 0) continue;
                this.downHostsCacheMap.remove(downHostsCacheKey);
            }
            this.lastPurge = LocalDateTime.now();
        }
    }

    private boolean isDownHostsCached(InetAddress inetAddress, int port) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(inetAddress.getHostAddress(), port);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    LocalDateTime markDownHost(ConnOption connOption) {
        if (connOption.inetSocketAddress != null && connOption.inetSocketAddress.getAddress() != null) {
            return this.downHostsCacheMap.put(new DownHostsCacheKey(connOption.inetSocketAddress.getAddress().getHostAddress(), connOption.port), LocalDateTime.now());
        }
        return this.downHostsCacheMap.put(new DownHostsCacheKey(connOption.addr, connOption.port), LocalDateTime.now());
    }

    private List<ConnOption> reorderConnOptions(List<ConnOption> connOptions) {
        if (connOptions.isEmpty()) {
            return connOptions;
        }
        ConnOption tConnOpt = connOptions.remove(0);
        if (this.isDownHostsCached(tConnOpt)) {
            this.reorderConnOptions(connOptions).add(tConnOpt);
        } else {
            this.reorderConnOptions(connOptions).add(0, tConnOpt);
        }
        return connOptions;
    }

    void reorderAddresses(List<ConnOption> connOptions) {
        this.refreshCache();
        connOptions = this.reorderConnOptions(connOptions);
    }

    private boolean isDownHostsCached(ConnOption connOption) {
        DownHostsCacheKey downHostsCacheKey = connOption.inetSocketAddress != null && connOption.inetSocketAddress.getAddress() != null ? new DownHostsCacheKey(connOption.inetSocketAddress.getAddress().getHostAddress(), connOption.port) : new DownHostsCacheKey(connOption.addr, connOption.port);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }
}

