/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import oracle.jdbc.provider.oson.OsonGenerator;

public class OsonLocalDateTimeSerializer
extends LocalDateTimeSerializer {
    public static final OsonLocalDateTimeSerializer INSTANCE = new OsonLocalDateTimeSerializer();

    public OsonLocalDateTimeSerializer() {
        super(null);
    }

    public OsonLocalDateTimeSerializer(DateTimeFormatter f) {
        super(f);
    }

    protected OsonLocalDateTimeSerializer(LocalDateTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter f) {
        super(base, useTimestamp, useNanoseconds, f);
    }

    protected LocalDateTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter f, JsonFormat.Shape shape) {
        return new OsonLocalDateTimeSerializer(this, useTimestamp, this._useNanoseconds, f);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return super._defaultFormatter();
    }

    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._formatter != null || this._shape != null) {
            super.serialize(value, gen, provider);
            return;
        }
        if (gen instanceof OsonGenerator) {
            ((OsonGenerator)gen).writeLocalDateTime(value);
        } else {
            super.serialize(value, gen, provider);
        }
    }

    public void serializeWithType(LocalDateTime value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        super.serializeWithType(value, g, provider, typeSer);
    }

    protected JsonToken serializationShape(SerializerProvider provider) {
        return super.serializationShape(provider);
    }

    protected LocalDateTimeSerializer withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return (LocalDateTimeSerializer)super.withFeatures(writeZoneId, writeNanoseconds);
    }
}

