/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDateTime;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonTimeStampDeserializer
extends DateDeserializers.TimestampDeserializer {
    public static final OsonTimeStampDeserializer INSTANCE = new OsonTimeStampDeserializer();

    public OsonTimeStampDeserializer() {
    }

    public OsonTimeStampDeserializer(DateDeserializers.TimestampDeserializer src, DateFormat df, String formatString) {
        super(src, df, formatString);
    }

    protected OsonTimeStampDeserializer withDateFormat(DateFormat df, String formatString) {
        return new OsonTimeStampDeserializer(this, df, formatString);
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return super.getEmptyValue(ctxt);
    }

    public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        OsonParser parser;
        if (this._customFormat != null) {
            return super.deserialize(p, ctxt);
        }
        if (p instanceof OsonParser && (parser = (OsonParser)p).currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_TIMESTAMP)) {
            LocalDateTime dateTime = parser.readLocalDateTime();
            return Timestamp.valueOf(dateTime);
        }
        return super.deserialize(p, ctxt);
    }
}

