/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonLocalDateDeserializer
extends LocalDateDeserializer {
    public static final OsonLocalDateDeserializer INSTANCE = new OsonLocalDateDeserializer();

    public OsonLocalDateDeserializer() {
    }

    public OsonLocalDateDeserializer(DateTimeFormatter dateFormat) {
        super(dateFormat);
    }

    public OsonLocalDateDeserializer(OsonLocalDateDeserializer base, DateTimeFormatter dtf) {
        super((LocalDateDeserializer)base, dtf);
    }

    public OsonLocalDateDeserializer(OsonLocalDateDeserializer base, Boolean leniency) {
        super((LocalDateDeserializer)base, leniency);
    }

    public OsonLocalDateDeserializer(OsonLocalDateDeserializer base, JsonFormat.Shape shape) {
        super((LocalDateDeserializer)base, shape);
    }

    protected OsonLocalDateDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new OsonLocalDateDeserializer(dtf);
    }

    protected OsonLocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new OsonLocalDateDeserializer(this, shape);
    }

    public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (this._shape != null || this._formatter != DateTimeFormatter.ISO_LOCAL_DATE) {
            return super.deserialize(parser, context);
        }
        if (parser instanceof OsonParser) {
            OsonParser _parser = (OsonParser)parser;
            if (_parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_DATE)) {
                LocalDateTime dateTime = _parser.readLocalDateTime();
                return dateTime.toLocalDate();
            }
        } else {
            return super.deserialize(parser, context);
        }
        return super.deserialize(parser, context);
    }
}

