/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import oracle.jdbc.provider.oson.OsonParser;

public class OsonBooleanDeserializer
extends StdScalarDeserializer<Boolean> {
    public static final OsonBooleanDeserializer INSTANCE = new OsonBooleanDeserializer();
    public static final NumberDeserializers.BooleanDeserializer WRAPPER_INSTANCE = new NumberDeserializers.BooleanDeserializer(Boolean.class, null);

    protected OsonBooleanDeserializer() {
        super(Boolean.class);
    }

    public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        if (p instanceof OsonParser) {
            switch (p.getCurrentToken()) {
                case VALUE_STRING: {
                    String str = p.getText();
                    if (str.equalsIgnoreCase("Y")) {
                        return Boolean.TRUE;
                    }
                    if (!str.equalsIgnoreCase("N")) break;
                    return Boolean.FALSE;
                }
            }
            return WRAPPER_INSTANCE.deserialize(p, ctxt);
        }
        return WRAPPER_INSTANCE.deserialize(p, ctxt);
    }
}

