/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sql.json.OracleJsonParser;

public class OsonParser
extends ParserBase {
    private static final boolean DEBUG = false;
    private final Logger logger = Logger.getLogger(OsonParser.class.getName());
    private final OracleJsonParser parser;
    private String fieldName;
    private OracleJsonParser.Event currentEvent;
    private OracleJsonParser.Event lastClearedEvent;
    private ObjectCodec _codec;
    private static final Map<OracleJsonParser.Event, JsonToken> OSON_EVENT_TO_JSON_TOKEN = new HashMap<OracleJsonParser.Event, JsonToken>();

    protected OsonParser(IOContext ctxt, int features, OracleJsonParser parser) {
        super(ctxt, features);
        this.parser = parser;
    }

    protected void _closeInput() throws IOException {
        this.parser.close();
    }

    private JsonToken fromOsonEvent(OracleJsonParser.Event event) {
        switch (event) {
            case KEY_NAME: {
                this.logger.log(Level.FINEST, "KEY_NAME> " + this.parser.getString());
                this.fieldName = this.parser.getString();
                return JsonToken.FIELD_NAME;
            }
            case VALUE_DECIMAL: {
                this.logger.log(Level.FINEST, "VALUE_DECIMAL> " + this.parser.getBigDecimal() + " / " + this.parser.isIntegralNumber());
                return this.parser.isIntegralNumber() ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_NUMBER_FLOAT;
            }
        }
        JsonToken token = OSON_EVENT_TO_JSON_TOKEN.get(this.currentEvent);
        if (token == null) {
            throw new IllegalStateException("Invalid event " + this.currentEvent);
        }
        this.logger.log(Level.FINEST, token.toString());
        return token;
    }

    public JsonToken nextToken() throws IOException {
        this.logger.log(Level.FINEST, "nextToken");
        if (this.parser.hasNext()) {
            this.currentEvent = this.parser.next();
            this._currToken = this.fromOsonEvent(this.currentEvent);
            return this._currToken;
        }
        return null;
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec oc) {
        this._codec = oc;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public JsonToken nextValue() throws IOException {
        this.logger.log(Level.FINEST, "nextValue");
        return super.nextValue();
    }

    public JsonParser skipChildren() throws IOException {
        this.logger.log(Level.FINEST, "skipChildren");
        if (this.currentEvent == null && this.parser.hasNext()) {
            this.currentEvent = this.parser.next();
        }
        if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            this.parser.skipArray();
        }
        if (this.currentEvent == OracleJsonParser.Event.START_OBJECT) {
            this.parser.skipObject();
        }
        return this;
    }

    public Object getEmbeddedObject() {
        this.logger.log(Level.FINEST, "getEmbeddedObject");
        if (this.currentEvent == OracleJsonParser.Event.VALUE_BINARY) {
            return this.parser.getBytes();
        }
        return null;
    }

    public boolean isExpectedStartObjectToken() {
        return this.currentEvent == OracleJsonParser.Event.START_OBJECT;
    }

    public boolean isExpectedStartArrayToken() {
        return this.currentEvent == OracleJsonParser.Event.START_ARRAY;
    }

    public JsonToken getCurrentToken() {
        this.logger.log(Level.FINEST, "getCurrentToken");
        if (this.currentEvent == null && this.parser.hasNext()) {
            this.currentEvent = this.parser.next();
        }
        this._currToken = this.fromOsonEvent(this.currentEvent);
        return this._currToken;
    }

    public JsonToken currentToken() {
        return this.getCurrentToken();
    }

    public int getCurrentTokenId() {
        return this.currentTokenId();
    }

    public int currentTokenId() {
        this.logger.log(Level.FINEST, "getCurrentTokenId");
        JsonToken jt = OSON_EVENT_TO_JSON_TOKEN.get(this.currentEvent);
        if (jt != null) {
            return jt.id();
        }
        if (this.currentEvent == OracleJsonParser.Event.VALUE_DECIMAL) {
            return this.parser.isIntegralNumber() ? JsonToken.VALUE_NUMBER_INT.id() : JsonToken.VALUE_NUMBER_FLOAT.id();
        }
        return 0;
    }

    public OracleJsonParser.Event currentOsonEvent() {
        return this.currentEvent;
    }

    public boolean hasCurrentToken() {
        this.logger.log(Level.FINEST, "hasCurrentToken");
        return this.currentEvent != null;
    }

    public boolean hasTokenId(int id) {
        this.logger.log(Level.FINEST, "hasTokenId( " + id + " )");
        if (id == 5) {
            return this.currentEvent == OracleJsonParser.Event.KEY_NAME;
        }
        if (id == 6) {
            return this.currentEvent == OracleJsonParser.Event.VALUE_STRING;
        }
        return false;
    }

    public boolean hasToken(JsonToken jsonToken) {
        this.logger.log(Level.FINEST, "hasToken( " + jsonToken + " )");
        JsonToken jt = OSON_EVENT_TO_JSON_TOKEN.get(this.currentEvent);
        if (jt != null) {
            return jt.id() == jsonToken.id();
        }
        if (this.currentEvent == OracleJsonParser.Event.VALUE_DECIMAL) {
            return this.parser.isIntegralNumber() ? JsonToken.VALUE_NUMBER_INT.id() == jsonToken.id() : JsonToken.VALUE_NUMBER_FLOAT.id() == jsonToken.id();
        }
        return false;
    }

    public void clearCurrentToken() {
        this.lastClearedEvent = this.currentEvent;
        this.currentEvent = null;
    }

    public JsonToken getLastClearedToken() {
        this.logger.log(Level.FINEST, "getLastClearedToken");
        if (this.lastClearedEvent == null) {
            return null;
        }
        return OSON_EVENT_TO_JSON_TOKEN.get(this.lastClearedEvent);
    }

    public void overrideCurrentName(String s) {
        this.fieldName = s;
    }

    public String getCurrentName() throws IOException {
        this.logger.log(Level.FINEST, "getCurrentName>" + this.fieldName);
        return this.fieldName;
    }

    public String getText() throws IOException {
        this.logger.log(Level.FINEST, "getText");
        return this.parser.getString();
    }

    public char[] getTextCharacters() throws IOException {
        this.logger.log(Level.FINEST, "getTextCharacters");
        return this.parser.getString().toCharArray();
    }

    public int getTextLength() throws IOException {
        this.logger.log(Level.FINEST, "getTextLength");
        return this.parser.getString().length();
    }

    public int getTextOffset() throws IOException {
        this.logger.log(Level.FINEST, "getTextOffset");
        return 0;
    }

    public Number getNumberValue() throws IOException {
        this.logger.log(Level.FINEST, "getNumberValue");
        return this.parser.getBigDecimal();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        this.logger.log(Level.FINEST, "getNumberType " + this.parser.isIntegralNumber());
        switch (this.currentEvent) {
            case VALUE_FLOAT: {
                return JsonParser.NumberType.FLOAT;
            }
            case VALUE_DECIMAL: {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
        }
        return null;
    }

    public int getIntValue() throws IOException {
        this.logger.log(Level.FINEST, "getIntValue");
        return this.parser.getInt();
    }

    public long getLongValue() throws IOException {
        this.logger.log(Level.FINEST, "getLongValue");
        return this.parser.getLong();
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this.parser.getBigInteger();
    }

    public float getFloatValue() throws IOException {
        return this.parser.getFloat();
    }

    public double getDoubleValue() throws IOException {
        return this.parser.getDouble();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this.parser.getBigDecimal();
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        this.logger.log(Level.FINEST, "getBinaryValue");
        byte[] result = this.currentEvent == OracleJsonParser.Event.VALUE_BINARY ? this.parser.getBytes() : super.getBinaryValue(base64Variant);
        this._binaryValue = null;
        return result;
    }

    public String getValueAsString(String s) throws IOException {
        this.logger.log(Level.FINEST, "getValueAsString");
        if (this.currentToken() == JsonToken.FIELD_NAME) {
            return this.fieldName;
        }
        return this.parser.getString();
    }

    public OffsetDateTime readOffsetDateTime() {
        this.logger.log(Level.FINEST, "readOffsetDateTime " + this.currentEvent);
        if (this.currentEvent == OracleJsonParser.Event.VALUE_STRING) {
            return OffsetDateTime.parse(this.parser.getString());
        }
        return this.parser.getOffsetDateTime();
    }

    public Duration readDuration() {
        this.logger.log(Level.FINEST, "readDuration " + this.currentEvent);
        if (this.currentEvent == OracleJsonParser.Event.VALUE_STRING) {
            return Duration.parse(this.parser.getString());
        }
        return this.parser.getDuration();
    }

    public Period readPeriod() {
        this.logger.log(Level.FINEST, "readPeriod " + this.currentEvent);
        if (this.currentEvent == OracleJsonParser.Event.VALUE_STRING) {
            return Period.parse(this.parser.getString());
        }
        return this.parser.getPeriod();
    }

    public LocalDateTime readLocalDateTime() {
        this.logger.log(Level.FINEST, "readLocalDateTime " + this.currentEvent);
        if (this.currentEvent == OracleJsonParser.Event.VALUE_STRING) {
            return LocalDateTime.parse(this.parser.getString());
        }
        return this.parser.getLocalDateTime();
    }

    static {
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.START_ARRAY, JsonToken.START_ARRAY);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.END_ARRAY, JsonToken.END_ARRAY);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.START_OBJECT, JsonToken.START_OBJECT);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.END_OBJECT, JsonToken.END_OBJECT);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.KEY_NAME, JsonToken.FIELD_NAME);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_STRING, JsonToken.VALUE_STRING);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_NULL, JsonToken.VALUE_NULL);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_TRUE, JsonToken.VALUE_TRUE);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_FALSE, JsonToken.VALUE_FALSE);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_DATE, JsonToken.VALUE_STRING);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_DOUBLE, JsonToken.VALUE_NUMBER_FLOAT);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_FLOAT, JsonToken.VALUE_NUMBER_FLOAT);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_TIMESTAMP, JsonToken.VALUE_STRING);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_TIMESTAMPTZ, JsonToken.VALUE_STRING);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_BINARY, JsonToken.VALUE_EMBEDDED_OBJECT);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_INTERVALDS, JsonToken.VALUE_STRING);
        OSON_EVENT_TO_JSON_TOKEN.put(OracleJsonParser.Event.VALUE_INTERVALYM, JsonToken.VALUE_STRING);
    }
}

