/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;

public class OsonGenerator
extends GeneratorBase {
    private static final boolean DEBUG = false;
    private Logger logger = Logger.getLogger(OsonGenerator.class.getName());
    private OutputStream out = null;
    private OracleJsonGenerator gen = null;
    private boolean closed;

    protected OsonGenerator(int features, ObjectCodec codec, OracleJsonGenerator gen, OutputStream out) {
        super(features, codec);
        this.out = out;
        this.gen = gen;
    }

    protected OsonGenerator(int features, ObjectCodec codec, OracleJsonGenerator gen) {
        super(features, codec);
        this.gen = gen;
    }

    public boolean canWriteBinaryNatively() {
        return true;
    }

    public void flush() throws IOException {
        this.logger.log(Level.FINEST, "flush");
        this.gen.flush();
    }

    protected void _releaseBuffers() {
        this.logger.log(Level.FINEST, "_releaseBuffers");
        if (this.out instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.out).reset();
        }
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("error: expecting value. Got name: " + typeMsg);
        }
    }

    public void writeStartArray() throws IOException {
        this._verifyValueWrite("writeStartArray");
        this.logger.log(Level.FINEST, "writeStartArray");
        this._writeContext = this._writeContext.createChildArrayContext();
        this.gen.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        int status = this._writeContext.writeValue();
        if (status != 1) {
            this._reportError("error: expecting end array");
        }
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this.logger.log(Level.FINEST, "writeEndArray");
        this.gen.writeEnd();
        this._writeContext = this._writeContext.getParent();
    }

    public void writeStartObject() throws IOException {
        this._verifyValueWrite("write start object");
        this.logger.log(Level.FINEST, "writeStartObject");
        this._writeContext = this._writeContext.createChildObjectContext();
        this.gen.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        int status = this._writeContext.writeValue();
        if (status != 5) {
            this._reportError("error: expecting end object");
        }
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an OBJECT but " + this._writeContext.getTypeDesc());
        }
        this.logger.log(Level.FINEST, "writeEndObject");
        this.gen.writeEnd();
        this._writeContext = this._writeContext.getParent();
    }

    public void writeFieldName(String name) throws IOException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.logger.log(Level.FINEST, "writeFieldName: " + name);
        this.gen.writeKey(name);
    }

    public void writeString(String text) throws IOException {
        this._verifyValueWrite("write string");
        this.logger.log(Level.FINEST, "writeString: " + text);
        this.gen.write(text);
    }

    public void writeString(char[] buffer, int offset, int len) throws IOException {
        this._verifyValueWrite("write string");
        this.logger.log(Level.FINEST, "writeString ");
        this.gen.write(new String(buffer, offset, len));
    }

    public void writeRawUTF8String(byte[] buffer, int offset, int len) throws IOException {
        this._verifyValueWrite("writeRawUTF8String");
        this.logger.log(Level.FINEST, "writeRawUTF8String ");
        this.gen.write(new String(buffer, offset, len, StandardCharsets.UTF_8));
    }

    public void writeUTF8String(byte[] buffer, int offset, int len) throws IOException {
        this._verifyValueWrite("writeUTF8String");
        this.logger.log(Level.FINEST, "writeUTF8String ");
        this.gen.write(new String(buffer, offset, len, StandardCharsets.UTF_8));
    }

    public void writeRaw(String text) throws IOException {
        this._verifyValueWrite("writeRaw");
        this.logger.log(Level.FINEST, "writeRaw: " + text);
        this.gen.write(text);
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this._verifyValueWrite("writeRaw");
        this.logger.log(Level.FINEST, "writeRaw: " + text);
        this.gen.write(text.substring(offset, offset + len));
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("writeRaw");
        this.logger.log(Level.FINEST, "writeRaw");
        this.gen.write(new String(text, offset, offset + len));
    }

    public void writeRaw(char c) throws IOException {
        this._verifyValueWrite("writeRaw");
        this.logger.log(Level.FINEST, "writeRaw: " + c);
        this.gen.write((int)c);
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        this._verifyValueWrite("writeBinary");
        this.logger.log(Level.FINEST, "writeBinary");
        this.gen.write(Arrays.copyOfRange(data, offset, offset + len));
    }

    public void writeNumber(int v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + v);
        this.gen.write(v);
    }

    public void writeNumber(long v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + v);
        this.gen.write(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + v);
        this.gen.write(v);
    }

    public void writeNumber(double v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + v);
        this.gen.write(v);
    }

    public void writeNumber(float v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + v);
        this.gen.write(v);
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber ");
        this.gen.write(v);
    }

    public void writeNumber(String encodedValue) throws IOException {
        this._verifyValueWrite("writeNumber");
        this.logger.log(Level.FINEST, "writeNumber: " + encodedValue);
        this.gen.write(new BigDecimal(encodedValue));
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("writeBoolean");
        this.logger.log(Level.FINEST, "writeBoolean: " + state);
        this.gen.write(state);
    }

    public void writeLocalDateTime(LocalDateTime v) throws IOException {
        this._verifyValueWrite("writeLocalDateTime");
        this.logger.log(Level.FINEST, "writeLocalDateTime:");
        this.gen.write(v);
    }

    public void writeOffsetDateTime(OffsetDateTime v) throws IOException {
        this._verifyValueWrite("writeOffsetDateTime");
        this.logger.log(Level.FINEST, "writeOffsetDateTime:");
        this.gen.write(v);
    }

    public void writeDuration(Duration v) throws IOException {
        this._verifyValueWrite("writeDuration");
        this.logger.log(Level.FINEST, "writeDuration:");
        this.gen.write(v);
    }

    public void writePeriod(Period v) throws IOException {
        this._verifyValueWrite("writePeriod");
        this.logger.log(Level.FINEST, "writePeriod:");
        this.gen.write(v);
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("writeNull");
        this.logger.log(Level.FINEST, "writeNull");
        this.gen.writeNull();
    }

    public boolean isClosed() {
        this.logger.log(Level.FINEST, "isClosed");
        return this.closed;
    }

    public void close() throws IOException {
        this.logger.log(Level.FINEST, "close");
        this.gen.close();
        this.closed = true;
    }

    public void writeDate(java.util.Date value) throws IOException {
        this._verifyValueWrite("write date");
        if (value instanceof Date) {
            this.logger.log(Level.FINEST, "writeDate: java.sql.Date");
            DATE dd = new DATE((Date)value);
            OracleJsonDateImpl jsonDate = new OracleJsonDateImpl(dd.shareBytes());
            this.gen.write((OracleJsonValue)jsonDate);
        } else {
            this.logger.log(Level.FINEST, "writeDate: java.util.Date");
            Timestamp ts = new Timestamp(value.getTime());
            TIMESTAMP timestamp = new TIMESTAMP(ts);
            OracleJsonTimestampImpl writeTimeStamp = new OracleJsonTimestampImpl(timestamp.shareBytes());
            this.gen.write((OracleJsonValue)writeTimeStamp);
        }
    }

    public void writeLocalDate(LocalDate value) throws IOException {
        this._verifyValueWrite("write LocalDate");
        this.logger.log(Level.FINEST, "writeLocalDate");
        try {
            DATE dd = new DATE(value);
            OracleJsonDateImpl jsonDate = new OracleJsonDateImpl(dd.shareBytes());
            this.gen.write((OracleJsonValue)jsonDate);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTimeStamp(Timestamp value) throws IOException {
        this._verifyValueWrite("write TimeStamp");
        this.logger.log(Level.FINEST, "writeTimeStamp");
        TIMESTAMP timestamp = new TIMESTAMP(value);
        OracleJsonTimestampImpl writeTimeStamp = new OracleJsonTimestampImpl(timestamp.shareBytes());
        this.gen.write((OracleJsonValue)writeTimeStamp);
    }
}

