/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.parameter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.provider.parameter.UriParameters;

final class ParameterSetParserImpl
implements ParameterSetParser {
    private final Map<String, ParameterParser> parameterParsers = new TreeMap<String, ParameterParser>(String.CASE_INSENSITIVE_ORDER);

    ParameterSetParserImpl(Builder builder) {
        this.parameterParsers.putAll(builder.parameterParsers);
    }

    @Override
    public ParameterSet parseNamedValues(Map<String, String> namedValues) {
        Objects.requireNonNull(namedValues, "namedValues is null");
        ParameterSetBuilder builder = ParameterSet.builder();
        Set missingKeys = this.parameterParsers.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        for (Map.Entry<String, String> namedValue : namedValues.entrySet()) {
            String name = namedValue.getKey();
            ParameterParser parameterParser = this.parameterParsers.get(name);
            missingKeys.remove(name.toLowerCase());
            if (parameterParser == null) {
                throw new IllegalArgumentException(String.format("Unrecognized parameter name: \"%s\". Valid parameter names are: %s", name, Arrays.toString(this.parameterParsers.keySet().toArray())));
            }
            parameterParser.setValue(builder, namedValue.getValue());
        }
        for (String missingKey : missingKeys) {
            this.parameterParsers.get(missingKey).setValue(builder, null);
        }
        return builder.build();
    }

    @Override
    public ParameterSet parseUrl(CharSequence url) {
        Map<String, String> parameters = UriParameters.parse(url);
        return this.parseNamedValues(parameters);
    }

    static final class Builder
    implements ParameterSetParser.Builder {
        private final Map<String, ParameterParser> parameterParsers = new HashMap<String, ParameterParser>();

        Builder() {
        }

        @Override
        public ParameterSetParser build() {
            return new ParameterSetParserImpl(this);
        }

        @Override
        public Builder addParameter(String name, Parameter<String> parameter) {
            this.addParameterParser(name, (value, builder) -> builder.add(name, parameter, value));
            return this;
        }

        @Override
        public Builder addParameter(String name, Parameter<String> parameter, String defaultValue) {
            this.addParameterParser(name, (value, builder) -> builder.add(name, parameter, value == null ? defaultValue : value));
            return this;
        }

        @Override
        public <T> Builder addParameter(String name, Parameter<T> parameter, Function<String, T> valueParser) {
            this.addParameterParser(name, (value, builder) -> builder.add(name, parameter, valueParser.apply((String)value)));
            return this;
        }

        @Override
        public <T> Builder addParameter(String name, Parameter<T> parameter, T defaultValue, Function<String, T> valueParser) {
            this.addParameterParser(name, (value, builder) -> {
                if (value != null) {
                    builder.add(name, parameter, valueParser.apply((String)value));
                } else {
                    builder.add(name, parameter, defaultValue);
                }
            });
            return this;
        }

        @Override
        public Builder addParameter(String name, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            this.addParameterParser(name, valueSetter);
            return this;
        }

        private void addParameterParser(String name, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            ParameterParser parameterParser = new ParameterParser(valueSetter);
            this.parameterParsers.put(name, parameterParser);
        }
    }

    private static final class ParameterParser {
        private final BiConsumer<String, ParameterSetBuilder> valueSetter;

        private ParameterParser(BiConsumer<String, ParameterSetBuilder> valueSetter) {
            this.valueSetter = valueSetter;
        }

        void setValue(ParameterSetBuilder builder, String value) {
            this.valueSetter.accept(value, builder);
        }
    }
}

