/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;

final class ParameterSetImpl
implements ParameterSet {
    private final Map<Parameter<?>, Object> parameterValues;
    private final Map<Parameter<?>, String> parameterNames;

    ParameterSetImpl(Map<Parameter<?>, Object> parameterValues, Map<Parameter<?>, String> parameterNames) {
        HashMap parameterValuesCopy = new HashMap(parameterValues);
        this.parameterValues = Collections.unmodifiableMap(parameterValuesCopy);
        HashMap parameterNamesCopy = new HashMap(parameterNames);
        this.parameterNames = Collections.unmodifiableMap(parameterNamesCopy);
    }

    @Override
    public boolean contains(Parameter<?> parameter) {
        return this.parameterValues.containsKey(parameter);
    }

    @Override
    public <T> T getOptional(Parameter<T> parameter) {
        Object value = this.parameterValues.get(parameter);
        return (T)value;
    }

    @Override
    public String getName(Parameter<?> parameter) {
        return this.parameterNames.get(parameter);
    }

    @Override
    public ParameterSetBuilder copyBuilder() {
        ParameterSetBuilder builder = ParameterSet.builder();
        for (Map.Entry<Parameter<?>, Object> parameterValue : this.parameterValues.entrySet()) {
            Parameter<?> parameter = parameterValue.getKey();
            Object value = parameterValue.getValue();
            String parameterName = this.parameterNames.get(parameter);
            builder.add(parameterName, parameter, value);
        }
        return builder;
    }

    public int hashCode() {
        return this.parameterValues.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParameterSetImpl && ((ParameterSetImpl)other).parameterValues.equals(this.parameterValues);
    }

    private Map<String, Object> getParameterKeyValuePairs() {
        return this.parameterNames.entrySet().stream().filter(entry -> this.parameterValues.get(entry.getKey()) != null).collect(Collectors.toMap(Map.Entry::getValue, entry -> this.parameterValues.get(entry.getKey())));
    }

    @Override
    public Map<String, Object> filterParameters(String[] relevantKeys) {
        Map<String, Object> allParameters = this.getParameterKeyValuePairs();
        List<String> relevantKeysList = Arrays.asList(relevantKeys);
        return allParameters.entrySet().stream().filter(entry -> relevantKeysList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String toString() {
        return this.parameterNames.entrySet().stream().map(entry -> String.format("%s=%s", entry.getValue(), ((Parameter)entry.getKey()).isSensitive() ? "[OMITTED]" : this.parameterValues.get(entry.getKey()))).collect(Collectors.joining(", "));
    }
}

