/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.provider.cache.CacheController;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class CachedResourceFactory<T>
implements ResourceFactory<T> {
    private static final int CACHE_SIZE = Integer.getInteger("oracle.jdbc.provider.CACHE_SIZE", 16);
    private final ResourceFactory<T> resourceFactory;
    private final ReentrantLock lock = new ReentrantLock();
    private final LruCache<ParameterSet, Future<Resource<T>>> values = new LruCache(CACHE_SIZE);

    private CachedResourceFactory(ResourceFactory<T> resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public static <T> ResourceFactory<T> create(ResourceFactory<T> resourceFactory) {
        CachedResourceFactory<T> cachedResourceFactory = new CachedResourceFactory<T>(resourceFactory);
        CacheController.register(cachedResourceFactory);
        return cachedResourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<T> request(ParameterSet parameterSet) {
        Future newResourceFuture;
        Resource<T> resource;
        Future existingResourceFuture;
        Objects.requireNonNull(parameterSet, "parameterSet is null");
        this.lock.lock();
        try {
            existingResourceFuture = (Future)this.values.get(parameterSet);
        }
        finally {
            this.lock.unlock();
        }
        if (existingResourceFuture != null && (resource = this.await(existingResourceFuture)).isValid()) {
            return resource;
        }
        FutureTask<Resource> newResourceTask = new FutureTask<Resource>(() -> this.resourceFactory.request(parameterSet));
        this.lock.lock();
        try {
            newResourceFuture = this.values.compute(parameterSet, (currentKey, currentResourceFuture) -> currentResourceFuture == existingResourceFuture ? newResourceTask : currentResourceFuture);
        }
        finally {
            this.lock.unlock();
        }
        if (newResourceFuture.equals(newResourceTask)) {
            newResourceTask.run();
        }
        return this.await(newResourceFuture);
    }

    public void clearCache() {
        this.lock.lock();
        try {
            this.values.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Resource<T> await(Future<Resource<T>> future) {
        try {
            return future.get();
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            throw new IllegalStateException(cause);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    private static final class LruCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maximumSize;

        private LruCache(int maximumSize) {
            super(maximumSize, 1.1f, true);
            this.maximumSize = maximumSize;
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.maximumSize;
        }
    }
}

