/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.cache;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.provider.cache.CachedResourceFactory;

public final class CacheController {
    private static final Set<WeakReference<CachedResourceFactory<?>>> FACTORIES = new HashSet();
    private static final ReentrantLock LOCK = new ReentrantLock();

    private CacheController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCaches() {
        LOCK.lock();
        try {
            HashSet clearedReferences = new HashSet(1);
            for (WeakReference<CachedResourceFactory<?>> reference : FACTORIES) {
                CachedResourceFactory cache = (CachedResourceFactory)reference.get();
                if (cache == null) {
                    clearedReferences.add(reference);
                    continue;
                }
                cache.clearCache();
            }
            FACTORIES.removeAll(clearedReferences);
        }
        finally {
            LOCK.unlock();
        }
    }

    static void register(CachedResourceFactory<?> factory) {
        LOCK.lock();
        try {
            FACTORIES.add(new WeakReference(factory));
        }
        finally {
            LOCK.unlock();
        }
    }
}

