/*
 * Copyright (C) 2018 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */
package com.opengamma.strata.product;

import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

import com.opengamma.strata.basics.location.Country;

/**
 * A simple legal entity implementation.
 */
@BeanDefinition(builderScope = "private", metaScope = "private", factoryName = "of")
public final class SimpleLegalEntity implements LegalEntity, Serializable, ImmutableBean {

  /**
   * The legal entity identifier.
   */
  @PropertyDefinition(validate = "notNull", overrideGet = true)
  private final LegalEntityId legalEntityId;
  /**
   * The legal entity name.
   */
  @PropertyDefinition(validate = "notNull", overrideGet = true)
  private final String name;
  /**
   * The country that the legal entity is based in.
   */
  @PropertyDefinition(validate = "notNull", overrideGet = true)
  private final Country country;

  //------------------------- AUTOGENERATED START -------------------------
  /**
   * The meta-bean for {@code SimpleLegalEntity}.
   * @return the meta-bean, not null
   */
  public static MetaBean meta() {
    return SimpleLegalEntity.Meta.INSTANCE;
  }

  static {
    MetaBean.register(SimpleLegalEntity.Meta.INSTANCE);
  }

  /**
   * The serialization version id.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Obtains an instance.
   * @param legalEntityId  the value of the property, not null
   * @param name  the value of the property, not null
   * @param country  the value of the property, not null
   * @return the instance
   */
  public static SimpleLegalEntity of(
      LegalEntityId legalEntityId,
      String name,
      Country country) {
    return new SimpleLegalEntity(
      legalEntityId,
      name,
      country);
  }

  private SimpleLegalEntity(
      LegalEntityId legalEntityId,
      String name,
      Country country) {
    JodaBeanUtils.notNull(legalEntityId, "legalEntityId");
    JodaBeanUtils.notNull(name, "name");
    JodaBeanUtils.notNull(country, "country");
    this.legalEntityId = legalEntityId;
    this.name = name;
    this.country = country;
  }

  @Override
  public MetaBean metaBean() {
    return SimpleLegalEntity.Meta.INSTANCE;
  }

  //-----------------------------------------------------------------------
  /**
   * Gets the legal entity identifier.
   * @return the value of the property, not null
   */
  @Override
  public LegalEntityId getLegalEntityId() {
    return legalEntityId;
  }

  //-----------------------------------------------------------------------
  /**
   * Gets the legal entity name.
   * @return the value of the property, not null
   */
  @Override
  public String getName() {
    return name;
  }

  //-----------------------------------------------------------------------
  /**
   * Gets the country that the legal entity is based in.
   * @return the value of the property, not null
   */
  @Override
  public Country getCountry() {
    return country;
  }

  //-----------------------------------------------------------------------
  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj != null && obj.getClass() == this.getClass()) {
      SimpleLegalEntity other = (SimpleLegalEntity) obj;
      return JodaBeanUtils.equal(legalEntityId, other.legalEntityId) &&
          JodaBeanUtils.equal(name, other.name) &&
          JodaBeanUtils.equal(country, other.country);
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = getClass().hashCode();
    hash = hash * 31 + JodaBeanUtils.hashCode(legalEntityId);
    hash = hash * 31 + JodaBeanUtils.hashCode(name);
    hash = hash * 31 + JodaBeanUtils.hashCode(country);
    return hash;
  }

  @Override
  public String toString() {
    StringBuilder buf = new StringBuilder(128);
    buf.append("SimpleLegalEntity{");
    buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString(legalEntityId)).append(',').append(' ');
    buf.append("name").append('=').append(JodaBeanUtils.toString(name)).append(',').append(' ');
    buf.append("country").append('=').append(JodaBeanUtils.toString(country));
    buf.append('}');
    return buf.toString();
  }

  //-----------------------------------------------------------------------
  /**
   * The meta-bean for {@code SimpleLegalEntity}.
   */
  private static final class Meta extends DirectMetaBean {
    /**
     * The singleton instance of the meta-bean.
     */
    static final Meta INSTANCE = new Meta();

    /**
     * The meta-property for the {@code legalEntityId} property.
     */
    private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable(
        this, "legalEntityId", SimpleLegalEntity.class, LegalEntityId.class);
    /**
     * The meta-property for the {@code name} property.
     */
    private final MetaProperty<String> name = DirectMetaProperty.ofImmutable(
        this, "name", SimpleLegalEntity.class, String.class);
    /**
     * The meta-property for the {@code country} property.
     */
    private final MetaProperty<Country> country = DirectMetaProperty.ofImmutable(
        this, "country", SimpleLegalEntity.class, Country.class);
    /**
     * The meta-properties.
     */
    private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap(
        this, null,
        "legalEntityId",
        "name",
        "country");

    /**
     * Restricted constructor.
     */
    private Meta() {
    }

    @Override
    protected MetaProperty<?> metaPropertyGet(String propertyName) {
      switch (propertyName.hashCode()) {
        case 866287159:  // legalEntityId
          return legalEntityId;
        case 3373707:  // name
          return name;
        case 957831062:  // country
          return country;
      }
      return super.metaPropertyGet(propertyName);
    }

    @Override
    public BeanBuilder<? extends SimpleLegalEntity> builder() {
      return new SimpleLegalEntity.Builder();
    }

    @Override
    public Class<? extends SimpleLegalEntity> beanType() {
      return SimpleLegalEntity.class;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
      return metaPropertyMap$;
    }

    //-----------------------------------------------------------------------
    @Override
    protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
      switch (propertyName.hashCode()) {
        case 866287159:  // legalEntityId
          return ((SimpleLegalEntity) bean).getLegalEntityId();
        case 3373707:  // name
          return ((SimpleLegalEntity) bean).getName();
        case 957831062:  // country
          return ((SimpleLegalEntity) bean).getCountry();
      }
      return super.propertyGet(bean, propertyName, quiet);
    }

    @Override
    protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
      metaProperty(propertyName);
      if (quiet) {
        return;
      }
      throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
    }

  }

  //-----------------------------------------------------------------------
  /**
   * The bean-builder for {@code SimpleLegalEntity}.
   */
  private static final class Builder extends DirectPrivateBeanBuilder<SimpleLegalEntity> {

    private LegalEntityId legalEntityId;
    private String name;
    private Country country;

    /**
     * Restricted constructor.
     */
    private Builder() {
    }

    //-----------------------------------------------------------------------
    @Override
    public Object get(String propertyName) {
      switch (propertyName.hashCode()) {
        case 866287159:  // legalEntityId
          return legalEntityId;
        case 3373707:  // name
          return name;
        case 957831062:  // country
          return country;
        default:
          throw new NoSuchElementException("Unknown property: " + propertyName);
      }
    }

    @Override
    public Builder set(String propertyName, Object newValue) {
      switch (propertyName.hashCode()) {
        case 866287159:  // legalEntityId
          this.legalEntityId = (LegalEntityId) newValue;
          break;
        case 3373707:  // name
          this.name = (String) newValue;
          break;
        case 957831062:  // country
          this.country = (Country) newValue;
          break;
        default:
          throw new NoSuchElementException("Unknown property: " + propertyName);
      }
      return this;
    }

    @Override
    public SimpleLegalEntity build() {
      return new SimpleLegalEntity(
          legalEntityId,
          name,
          country);
    }

    //-----------------------------------------------------------------------
    @Override
    public String toString() {
      StringBuilder buf = new StringBuilder(128);
      buf.append("SimpleLegalEntity.Builder{");
      buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString(legalEntityId)).append(',').append(' ');
      buf.append("name").append('=').append(JodaBeanUtils.toString(name)).append(',').append(' ');
      buf.append("country").append('=').append(JodaBeanUtils.toString(country));
      buf.append('}');
      return buf.toString();
    }

  }

  //-------------------------- AUTOGENERATED END --------------------------
}
