/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.DefaultFxRateLookup;
import com.opengamma.strata.calc.runner.MatrixFxRateLookup;
import com.opengamma.strata.data.FxMatrixId;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.ObservableSource;

public interface FxRateLookup
extends CalculationParameter {
    public static FxRateLookup ofRates() {
        return DefaultFxRateLookup.DEFAULT;
    }

    public static FxRateLookup ofRates(ObservableSource observableSource) {
        return new DefaultFxRateLookup(observableSource);
    }

    public static FxRateLookup ofRates(Currency triangulationCurrency) {
        return new DefaultFxRateLookup(triangulationCurrency, ObservableSource.NONE);
    }

    public static FxRateLookup ofRates(Currency triangulationCurrency, ObservableSource observableSource) {
        return new DefaultFxRateLookup(triangulationCurrency, observableSource);
    }

    public static FxRateLookup ofMatrix() {
        return MatrixFxRateLookup.DEFAULT;
    }

    public static FxRateLookup ofMatrix(FxMatrixId matrixId) {
        return new MatrixFxRateLookup(matrixId);
    }

    @Override
    default public Class<? extends CalculationParameter> queryType() {
        return FxRateLookup.class;
    }

    public FxRateProvider fxRateProvider(MarketData var1);
}

