/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationFunctions;
import com.opengamma.strata.calc.runner.DerivedCalculationFunction;
import com.opengamma.strata.calc.runner.DerivedCalculationFunctionWrapper;
import java.util.List;
import java.util.Optional;

class DerivedCalculationFunctions
implements CalculationFunctions {
    private final CalculationFunctions delegateFunctions;
    private final ListMultimap<Class<?>, DerivedCalculationFunction<?, ?>> functionsByTargetType;

    DerivedCalculationFunctions(CalculationFunctions delegateFunctions, List<DerivedCalculationFunction<?, ?>> functions) {
        this.delegateFunctions = delegateFunctions;
        ArrayListMultimap listMultimap = ArrayListMultimap.create();
        for (DerivedCalculationFunction<?, ?> fn : functions) {
            listMultimap.put(fn.targetType(), fn);
        }
        this.functionsByTargetType = listMultimap;
    }

    @Override
    public <T extends CalculationTarget> Optional<CalculationFunction<? super T>> findFunction(T target) {
        return this.delegateFunctions.findFunction(target).map(fn -> this.wrap((CalculationFunction)fn, target));
    }

    private <T extends CalculationTarget, R> CalculationFunction<? super T> wrap(CalculationFunction<? super T> fn, T target) {
        List derivedFunctions = this.functionsByTargetType.get(target.getClass());
        if (derivedFunctions == null) {
            return fn;
        }
        CalculationFunction<? super T> wrappedFn = fn;
        for (DerivedCalculationFunction derivedFn : derivedFunctions) {
            CalculationFunction<? super T> wrappedFnCast = wrappedFn;
            DerivedCalculationFunction derivedFnCast = derivedFn;
            wrappedFn = new DerivedCalculationFunctionWrapper(derivedFnCast, wrappedFnCast);
        }
        return wrappedFn;
    }
}

