/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.DerivedCalculationFunction;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class DerivedCalculationFunctionWrapper<T extends CalculationTarget, R>
implements CalculationFunction<T> {
    private final DerivedCalculationFunction<T, R> derivedFunction;
    private final CalculationFunction<T> delegate;
    private final Set<Measure> supportedMeasures;
    private final boolean requiredMeasuresSupported;

    DerivedCalculationFunctionWrapper(DerivedCalculationFunction<T, R> derivedFunction, CalculationFunction<T> delegate) {
        this.derivedFunction = derivedFunction;
        this.delegate = delegate;
        ImmutableSet delegateMeasures = delegate.supportedMeasures();
        this.requiredMeasuresSupported = delegateMeasures.containsAll(derivedFunction.requiredMeasures());
        this.supportedMeasures = this.requiredMeasuresSupported ? ImmutableSet.builder().addAll(delegateMeasures).add((Object)derivedFunction.measure()).build() : delegateMeasures;
    }

    @Override
    public Class<T> targetType() {
        return this.derivedFunction.targetType();
    }

    @Override
    public Set<Measure> supportedMeasures() {
        return this.supportedMeasures;
    }

    @Override
    public Optional<String> identifier(T target) {
        return this.delegate.identifier(target);
    }

    @Override
    public Currency naturalCurrency(T target, ReferenceData refData) {
        return this.delegate.naturalCurrency(target, refData);
    }

    @Override
    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        FunctionRequirements delegateRequirements = this.delegate.requirements(target, measures, parameters, refData);
        FunctionRequirements functionRequirements = this.derivedFunction.requirements(target, parameters, refData);
        return delegateRequirements.combinedWith(functionRequirements);
    }

    @Override
    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData marketData, ReferenceData refData) {
        Measure derivedMeasure = this.derivedFunction.measure();
        if (!measures.contains(derivedMeasure)) {
            return this.delegate.calculate(target, measures, parameters, marketData, refData);
        }
        Sets.SetView allRequiredMeasures = Sets.union(measures, this.derivedFunction.requiredMeasures());
        Sets.SetView requiredMeasures = Sets.difference((Set)allRequiredMeasures, (Set)ImmutableSet.of((Object)derivedMeasure));
        Map<Measure, Result<?>> delegateResults = this.delegate.calculate(target, (Set<Measure>)requiredMeasures, parameters, marketData, refData);
        Result<?> result = this.calculateMeasure(target, delegateResults, parameters, marketData, refData);
        ImmutableMap requestedResults = MapStream.of(delegateResults).filterKeys(measures::contains).filterKeys(measure -> !measure.equals(derivedMeasure)).toMap();
        return ImmutableMap.builder().put((Object)derivedMeasure, result).putAll((Map)requestedResults).build();
    }

    private Result<?> calculateMeasure(T target, Map<Measure, Result<?>> delegateResults, CalculationParameters parameters, ScenarioMarketData marketData, ReferenceData refData) {
        if (!this.requiredMeasuresSupported) {
            return Result.failure((FailureReason)FailureReason.NOT_APPLICABLE, (String)"The delegate function cannot calculate the required measures. Required measures: {}, supported measures: {}, delegate {}", (Object[])new Object[]{this.derivedFunction.requiredMeasures(), this.delegate.supportedMeasures(), this.delegate});
        }
        if (!delegateResults.keySet().containsAll(this.derivedFunction.requiredMeasures())) {
            return Result.failure((FailureReason)FailureReason.CALCULATION_FAILED, (String)"Delegate did not return the expected measures. Required {}, actual {}, delegate {}", (Object[])new Object[]{this.derivedFunction.requiredMeasures(), delegateResults.keySet(), this.delegate});
        }
        List failures = MapStream.of(delegateResults).filterKeys(this.derivedFunction.requiredMeasures()::contains).map(entry -> (Result)entry.getValue()).filter(result -> result.isFailure()).collect(Collectors.toList());
        if (!failures.isEmpty()) {
            return Result.failure(failures);
        }
        ImmutableMap resultValues = MapStream.of(delegateResults).filterKeys(this.derivedFunction.requiredMeasures()::contains).mapValues(result -> result.getValue()).toMap();
        return Result.of(() -> this.lambda$calculateMeasure$4(target, (Map)resultValues, parameters, marketData, refData));
    }

    private /* synthetic */ Object lambda$calculateMeasure$4(CalculationTarget target, Map resultValues, CalculationParameters parameters, ScenarioMarketData marketData, ReferenceData refData) {
        return this.derivedFunction.calculate(target, resultValues, parameters, marketData, refData);
    }
}

