/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationFunctions;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class CompositeCalculationFunctions
implements CalculationFunctions,
ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final CalculationFunctions functions1;
    @PropertyDefinition(validate="notNull")
    private final CalculationFunctions functions2;
    private static final TypedMetaBean<CompositeCalculationFunctions> META_BEAN = LightMetaBean.of(CompositeCalculationFunctions.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"functions1", "functions2"}, (Object[])new Object[0]);

    static CompositeCalculationFunctions of(CalculationFunctions functions1, CalculationFunctions functions2) {
        return new CompositeCalculationFunctions(functions1, functions2);
    }

    @Override
    public <T extends CalculationTarget> Optional<CalculationFunction<? super T>> findFunction(T target) {
        Optional<CalculationFunction<CalculationFunction<T>>> function = this.functions1.findFunction(target);
        return function.isPresent() ? function : this.functions2.findFunction(target);
    }

    public static TypedMetaBean<CompositeCalculationFunctions> meta() {
        return META_BEAN;
    }

    private CompositeCalculationFunctions(CalculationFunctions functions1, CalculationFunctions functions2) {
        JodaBeanUtils.notNull((Object)functions1, (String)"functions1");
        JodaBeanUtils.notNull((Object)functions2, (String)"functions2");
        this.functions1 = functions1;
        this.functions2 = functions2;
    }

    public TypedMetaBean<CompositeCalculationFunctions> metaBean() {
        return META_BEAN;
    }

    public CalculationFunctions getFunctions1() {
        return this.functions1;
    }

    public CalculationFunctions getFunctions2() {
        return this.functions2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CompositeCalculationFunctions other = (CompositeCalculationFunctions)obj;
            return JodaBeanUtils.equal((Object)this.functions1, (Object)other.functions1) && JodaBeanUtils.equal((Object)this.functions2, (Object)other.functions2);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.functions1);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.functions2);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CompositeCalculationFunctions{");
        buf.append("functions1").append('=').append(JodaBeanUtils.toString((Object)this.functions1)).append(',').append(' ');
        buf.append("functions2").append('=').append(JodaBeanUtils.toString((Object)this.functions2));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

