/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ResolvableCalculationTarget;
import com.opengamma.strata.calc.CalculationRules;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.ReportingCurrency;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.calc.marketdata.MarketDataRequirementsBuilder;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.CalculationTask;
import com.opengamma.strata.calc.runner.CalculationTaskCell;
import com.opengamma.strata.calc.runner.UnresolvableTarget;
import com.opengamma.strata.calc.runner.UnresolvableTargetCalculationFunction;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class CalculationTasks
implements ImmutableBean {
    @PropertyDefinition(validate="notEmpty")
    private final List<CalculationTarget> targets;
    @PropertyDefinition(validate="notEmpty")
    private final List<Column> columns;
    @PropertyDefinition(validate="notEmpty")
    private final List<CalculationTask> tasks;
    private static final TypedMetaBean<CalculationTasks> META_BEAN = LightMetaBean.of(CalculationTasks.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"targets", "columns", "tasks"}, (Object[])new Object[]{ImmutableList.of(), ImmutableList.of(), ImmutableList.of()});

    public static CalculationTasks of(CalculationRules rules, List<? extends CalculationTarget> targets, List<Column> columns) {
        return CalculationTasks.of(rules, targets, columns, ReferenceData.empty());
    }

    public static CalculationTasks of(CalculationRules rules, List<? extends CalculationTarget> targets, List<Column> columns, ReferenceData refData) {
        List effectiveColumns = (List)columns.stream().map(column -> column.combineWithDefaults(rules.getReportingCurrency(), rules.getParameters())).collect(Guavate.toImmutableList());
        ImmutableList.Builder taskBuilder = ImmutableList.builder();
        for (int rowIndex = 0; rowIndex < targets.size(); ++rowIndex) {
            CalculationTarget target = CalculationTasks.resolveTarget(targets.get(rowIndex), refData);
            CalculationFunction<UnresolvableTarget> fn = target instanceof UnresolvableTarget ? UnresolvableTargetCalculationFunction.INSTANCE : rules.getFunctions().getFunction(target);
            List<CalculationTask> targetTasks = CalculationTasks.createTargetTasks(target, rowIndex, fn, effectiveColumns);
            taskBuilder.addAll(targetTasks);
        }
        return new CalculationTasks((List<CalculationTask>)taskBuilder.build(), columns);
    }

    private static CalculationTarget resolveTarget(CalculationTarget target, ReferenceData refData) {
        if (target instanceof ResolvableCalculationTarget) {
            ResolvableCalculationTarget resolvable = (ResolvableCalculationTarget)target;
            try {
                return resolvable.resolveTarget(refData);
            }
            catch (RuntimeException ex) {
                return new UnresolvableTarget(resolvable, ex.getMessage());
            }
        }
        return target;
    }

    private static List<CalculationTask> createTargetTasks(CalculationTarget resolvedTarget, int rowIndex, CalculationFunction<?> function, List<Column> columns) {
        ArrayListMultimap grouped = ArrayListMultimap.create();
        for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
            Column column = columns.get(colIndex);
            Measure measure = column.getMeasure();
            ReportingCurrency reportingCurrency = column.getReportingCurrency().orElse(ReportingCurrency.NATURAL);
            CalculationTaskCell cell = CalculationTaskCell.of(rowIndex, colIndex, measure, reportingCurrency);
            CalculationParameters params = column.getParameters().filter(resolvedTarget, measure);
            grouped.put((Object)params, (Object)cell);
        }
        ImmutableList.Builder taskBuilder = ImmutableList.builder();
        for (CalculationParameters params : grouped.keySet()) {
            taskBuilder.add((Object)CalculationTask.of(resolvedTarget, function, params, grouped.get((Object)params)));
        }
        return taskBuilder.build();
    }

    public static CalculationTasks of(List<CalculationTask> tasks, List<Column> columns) {
        return new CalculationTasks(tasks, columns);
    }

    private CalculationTasks(List<CalculationTask> tasks, List<Column> columns) {
        this.columns = ImmutableList.copyOf(columns);
        this.tasks = ImmutableList.copyOf(tasks);
        long cellCount = tasks.stream().flatMap(task -> task.getCells().stream()).count();
        int columnCount = columns.size();
        if (cellCount != 0L) {
            if (columnCount == 0) {
                throw new IllegalArgumentException("There must be at least one column");
            }
            if (cellCount % (long)columnCount != 0L) {
                throw new IllegalArgumentException(Messages.format((String)"Number of cells ({}) must be exactly divisible by the number of columns ({})", (Object[])new Object[]{cellCount, columnCount}));
            }
        }
        int targetCount = (int)cellCount / columnCount;
        Object[] targets = new CalculationTarget[targetCount];
        for (CalculationTask task2 : tasks) {
            int rowIdx = task2.getRowIndex();
            if (targets[rowIdx] == null) {
                targets[rowIdx] = task2.getTarget();
                continue;
            }
            if (targets[rowIdx] == task2.getTarget()) continue;
            throw new IllegalArgumentException(Messages.format((String)"Tasks define two different targets for row {}: {} and {}", (Object[])new Object[]{rowIdx, targets[rowIdx], task2.getTarget()}));
        }
        this.targets = ImmutableList.copyOf((Object[])targets);
    }

    public MarketDataRequirements requirements(ReferenceData refData) {
        MarketDataRequirementsBuilder builder = MarketDataRequirements.builder();
        for (CalculationTask task : this.tasks) {
            builder.addRequirements(task.requirements(refData));
        }
        return builder.build();
    }

    public String toString() {
        return Messages.format((String)"CalculationTasks[grid={}x{}]", (Object[])new Object[]{this.targets.size(), this.columns.size()});
    }

    public static TypedMetaBean<CalculationTasks> meta() {
        return META_BEAN;
    }

    private CalculationTasks(List<CalculationTarget> targets, List<Column> columns, List<CalculationTask> tasks) {
        JodaBeanUtils.notEmpty(targets, (String)"targets");
        JodaBeanUtils.notEmpty(columns, (String)"columns");
        JodaBeanUtils.notEmpty(tasks, (String)"tasks");
        this.targets = ImmutableList.copyOf(targets);
        this.columns = ImmutableList.copyOf(columns);
        this.tasks = ImmutableList.copyOf(tasks);
    }

    public TypedMetaBean<CalculationTasks> metaBean() {
        return META_BEAN;
    }

    public List<CalculationTarget> getTargets() {
        return this.targets;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<CalculationTask> getTasks() {
        return this.tasks;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationTasks other = (CalculationTasks)obj;
            return JodaBeanUtils.equal(this.targets, other.targets) && JodaBeanUtils.equal(this.columns, other.columns) && JodaBeanUtils.equal(this.tasks, other.tasks);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.targets);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.columns);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.tasks);
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

