/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CompositeCalculationFunctions;
import com.opengamma.strata.calc.runner.DefaultCalculationFunctions;
import com.opengamma.strata.calc.runner.DerivedCalculationFunction;
import com.opengamma.strata.calc.runner.DerivedCalculationFunctions;
import com.opengamma.strata.calc.runner.MissingConfigCalculationFunction;
import com.opengamma.strata.collect.Guavate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface CalculationFunctions {
    public static CalculationFunctions empty() {
        return DefaultCalculationFunctions.EMPTY;
    }

    public static CalculationFunctions of(CalculationFunction<?> ... functions) {
        return DefaultCalculationFunctions.of((Map)Stream.of(functions).collect(Guavate.toImmutableMap(fn -> fn.targetType())));
    }

    public static CalculationFunctions of(List<? extends CalculationFunction<?>> functions) {
        return DefaultCalculationFunctions.of((Map)functions.stream().collect(Guavate.toImmutableMap(fn -> fn.targetType())));
    }

    public static CalculationFunctions of(Map<Class<?>, ? extends CalculationFunction<?>> functions) {
        return DefaultCalculationFunctions.of(functions);
    }

    default public <T extends CalculationTarget> CalculationFunction<? super T> getFunction(T target) {
        return this.findFunction(target).orElse(MissingConfigCalculationFunction.INSTANCE);
    }

    public <T extends CalculationTarget> Optional<CalculationFunction<? super T>> findFunction(T var1);

    default public CalculationFunctions composedWith(CalculationFunctions other) {
        return CompositeCalculationFunctions.of(this, other);
    }

    default public CalculationFunctions composedWith(DerivedCalculationFunction<?, ?> ... functions) {
        return new DerivedCalculationFunctions(this, Arrays.asList(functions));
    }

    default public CalculationFunctions composedWith(List<DerivedCalculationFunction<?, ?>> functions) {
        return new DerivedCalculationFunctions(this, functions);
    }
}

