/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
final class SingleTypeMarketDataConfig
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Class<?> configType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<String, Object> configObjects;
    private static final long serialVersionUID = 1L;

    Object get(String name) {
        Object config = this.configObjects.get((Object)name);
        if (config == null) {
            throw new IllegalArgumentException(Messages.format((String)"No configuration found with type {} and name {}", (Object[])new Object[]{this.configType.getName(), name}));
        }
        return config;
    }

    SingleTypeMarketDataConfig withConfig(String name, Object config) {
        ArgChecker.notEmpty((String)name, (String)"name");
        ArgChecker.notNull((Object)config, (String)"config");
        if (!this.configType.equals(config.getClass())) {
            throw new IllegalArgumentException(Messages.format((String)"Configuration object {} is not of the required type {}", (Object[])new Object[]{config, this.configType.getName()}));
        }
        HashMap<String, Object> configCopy = new HashMap<String, Object>((Map<String, Object>)this.configObjects);
        configCopy.put(name, config);
        return new SingleTypeMarketDataConfig(this.configType, configCopy);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    static Builder builder() {
        return new Builder();
    }

    private SingleTypeMarketDataConfig(Class<?> configType, Map<String, Object> configObjects) {
        JodaBeanUtils.notNull(configType, (String)"configType");
        JodaBeanUtils.notNull(configObjects, (String)"configObjects");
        this.configType = configType;
        this.configObjects = ImmutableMap.copyOf(configObjects);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Class<?> getConfigType() {
        return this.configType;
    }

    public ImmutableMap<String, Object> getConfigObjects() {
        return this.configObjects;
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SingleTypeMarketDataConfig other = (SingleTypeMarketDataConfig)obj;
            return JodaBeanUtils.equal(this.configType, other.configType) && JodaBeanUtils.equal(this.configObjects, other.configObjects);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.configType);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.configObjects);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("SingleTypeMarketDataConfig{");
        buf.append("configType").append('=').append(JodaBeanUtils.toString(this.configType)).append(',').append(' ');
        buf.append("configObjects").append('=').append(JodaBeanUtils.toString(this.configObjects));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    static final class Builder
    extends DirectFieldsBeanBuilder<SingleTypeMarketDataConfig> {
        private Class<?> configType;
        private Map<String, Object> configObjects = ImmutableMap.of();

        private Builder() {
        }

        private Builder(SingleTypeMarketDataConfig beanToCopy) {
            this.configType = beanToCopy.getConfigType();
            this.configObjects = beanToCopy.getConfigObjects();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 831526300: {
                    return this.configType;
                }
                case 2117143410: {
                    return this.configObjects;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 831526300: {
                    this.configType = (Class)newValue;
                    break;
                }
                case 2117143410: {
                    this.configObjects = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SingleTypeMarketDataConfig build() {
            return new SingleTypeMarketDataConfig(this.configType, this.configObjects);
        }

        public Builder configType(Class<?> configType) {
            JodaBeanUtils.notNull(configType, (String)"configType");
            this.configType = configType;
            return this;
        }

        public Builder configObjects(Map<String, Object> configObjects) {
            JodaBeanUtils.notNull(configObjects, (String)"configObjects");
            this.configObjects = configObjects;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("SingleTypeMarketDataConfig.Builder{");
            buf.append("configType").append('=').append(JodaBeanUtils.toString(this.configType)).append(',').append(' ');
            buf.append("configObjects").append('=').append(JodaBeanUtils.toString(this.configObjects));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Class<?>> configType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"configType", SingleTypeMarketDataConfig.class, Class.class);
        private final MetaProperty<ImmutableMap<String, Object>> configObjects = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"configObjects", SingleTypeMarketDataConfig.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"configType", "configObjects"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 831526300: {
                    return this.configType;
                }
                case 2117143410: {
                    return this.configObjects;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SingleTypeMarketDataConfig> beanType() {
            return SingleTypeMarketDataConfig.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Class<?>> configType() {
            return this.configType;
        }

        public MetaProperty<ImmutableMap<String, Object>> configObjects() {
            return this.configObjects;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 831526300: {
                    return ((SingleTypeMarketDataConfig)bean).getConfigType();
                }
                case 2117143410: {
                    return ((SingleTypeMarketDataConfig)bean).getConfigObjects();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

