/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.calc.marketdata.PerturbationMapping;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ScenarioDefinition
implements ImmutableBean {
    @PropertyDefinition(validate="notNull", builderType="List<? extends PerturbationMapping<?>>")
    private final ImmutableList<PerturbationMapping<?>> mappings;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<String> scenarioNames;
    private static final ScenarioDefinition EMPTY = ScenarioDefinition.builder().build();

    public static ScenarioDefinition empty() {
        return EMPTY;
    }

    public static ScenarioDefinition ofMappings(List<? extends PerturbationMapping<?>> mapping) {
        ArgChecker.notEmpty(mapping, (String)"mappings");
        int numScenarios = ScenarioDefinition.countScenarios(mapping, false);
        for (int i = 1; i < mapping.size(); ++i) {
            if (mapping.get(i).getScenarioCount() == numScenarios) continue;
            throw new IllegalArgumentException("All mappings must have the same number of perturbations. First mapping has " + numScenarios + " perturbations, mapping " + i + " has " + mapping.get(i).getScenarioCount());
        }
        return new ScenarioDefinition((List<? extends PerturbationMapping<?>>)mapping, (List<String>)ScenarioDefinition.generateNames(numScenarios));
    }

    public static ScenarioDefinition ofMappings(PerturbationMapping<?> ... mappings) {
        return ScenarioDefinition.ofMappings(Arrays.asList(mappings));
    }

    public static ScenarioDefinition ofMappings(List<? extends PerturbationMapping<?>> mappings, List<String> scenarioNames) {
        ArgChecker.notNull(scenarioNames, (String)"scenarioNames");
        int numScenarios = scenarioNames.size();
        for (int i = 0; i < mappings.size(); ++i) {
            if (mappings.get(i).getScenarioCount() == numScenarios) continue;
            throw new IllegalArgumentException("Each mapping must contain the same number of scenarios as the definition. There are " + numScenarios + " scenarios in the definition, mapping " + i + " has " + mappings.get(i).getScenarioCount() + " scenarios.");
        }
        return new ScenarioDefinition(mappings, scenarioNames);
    }

    private static int countScenarios(List<? extends PerturbationMapping<?>> mappings, boolean allCombinations) {
        ArgChecker.notEmpty(mappings, (String)"mappings");
        if (allCombinations) {
            return mappings.stream().mapToInt(PerturbationMapping::getScenarioCount).reduce(1, (s1, s2) -> s1 * s2);
        }
        return mappings.get(0).getScenarioCount();
    }

    static <T> List<T> repeatItems(List<T> inputs, int totalCount, int groupSize) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < totalCount / groupSize / inputs.size(); ++i) {
            for (T input : inputs) {
                builder.addAll(Collections.nCopies(groupSize, input));
            }
        }
        return builder.build();
    }

    private static ImmutableList<String> generateNames(int numScenarios) {
        return (ImmutableList)IntStream.range(1, numScenarios + 1).mapToObj(i -> "Scenario " + i).collect(Guavate.toImmutableList());
    }

    @ImmutableValidator
    private void validate() {
        Map<String, List<String>> nameMap = this.scenarioNames.stream().collect(Collectors.groupingBy(name -> name));
        List duplicateNames = (List)MapStream.of(nameMap).filterValues(names -> names.size() > 1).map((name, names) -> name).collect(Guavate.toImmutableList());
        if (!duplicateNames.isEmpty()) {
            String duplicates = duplicateNames.stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Scenario names must be unique but duplicates were found: " + duplicates);
        }
    }

    public int getScenarioCount() {
        return this.scenarioNames.size();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ScenarioDefinition(List<? extends PerturbationMapping<?>> mappings, List<String> scenarioNames) {
        JodaBeanUtils.notNull(mappings, (String)"mappings");
        JodaBeanUtils.notNull(scenarioNames, (String)"scenarioNames");
        this.mappings = ImmutableList.copyOf(mappings);
        this.scenarioNames = ImmutableList.copyOf(scenarioNames);
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<PerturbationMapping<?>> getMappings() {
        return this.mappings;
    }

    public ImmutableList<String> getScenarioNames() {
        return this.scenarioNames;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ScenarioDefinition other = (ScenarioDefinition)obj;
            return JodaBeanUtils.equal(this.mappings, other.mappings) && JodaBeanUtils.equal(this.scenarioNames, other.scenarioNames);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.mappings);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.scenarioNames);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ScenarioDefinition{");
        buf.append("mappings").append('=').append(JodaBeanUtils.toString(this.mappings)).append(',').append(' ');
        buf.append("scenarioNames").append('=').append(JodaBeanUtils.toString(this.scenarioNames));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ScenarioDefinition> {
        private List<? extends PerturbationMapping<?>> mappings = ImmutableList.of();
        private List<String> scenarioNames = ImmutableList.of();

        private Builder() {
        }

        private Builder(ScenarioDefinition beanToCopy) {
            this.mappings = beanToCopy.getMappings();
            this.scenarioNames = beanToCopy.getScenarioNames();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 194445669: {
                    return this.mappings;
                }
                case -1193464424: {
                    return this.scenarioNames;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 194445669: {
                    this.mappings = (List)newValue;
                    break;
                }
                case -1193464424: {
                    this.scenarioNames = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ScenarioDefinition build() {
            return new ScenarioDefinition(this.mappings, this.scenarioNames);
        }

        public Builder mappings(List<? extends PerturbationMapping<?>> mappings) {
            JodaBeanUtils.notNull(mappings, (String)"mappings");
            this.mappings = mappings;
            return this;
        }

        @SafeVarargs
        public final Builder mappings(PerturbationMapping<?> ... mappings) {
            return this.mappings((List<? extends PerturbationMapping<?>>)ImmutableList.copyOf((Object[])mappings));
        }

        public Builder scenarioNames(List<String> scenarioNames) {
            JodaBeanUtils.notNull(scenarioNames, (String)"scenarioNames");
            this.scenarioNames = scenarioNames;
            return this;
        }

        public Builder scenarioNames(String ... scenarioNames) {
            return this.scenarioNames((List<String>)ImmutableList.copyOf((Object[])scenarioNames));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ScenarioDefinition.Builder{");
            buf.append("mappings").append('=').append(JodaBeanUtils.toString(this.mappings)).append(',').append(' ');
            buf.append("scenarioNames").append('=').append(JodaBeanUtils.toString(this.scenarioNames));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<PerturbationMapping<?>>> mappings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"mappings", ScenarioDefinition.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<String>> scenarioNames = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"scenarioNames", ScenarioDefinition.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"mappings", "scenarioNames"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 194445669: {
                    return this.mappings;
                }
                case -1193464424: {
                    return this.scenarioNames;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ScenarioDefinition> beanType() {
            return ScenarioDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<PerturbationMapping<?>>> mappings() {
            return this.mappings;
        }

        public MetaProperty<ImmutableList<String>> scenarioNames() {
            return this.scenarioNames;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 194445669: {
                    return ((ScenarioDefinition)bean).getMappings();
                }
                case -1193464424: {
                    return ((ScenarioDefinition)bean).getScenarioNames();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

