/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class MarketDataRequirementsBuilder {
    private final Set<ObservableId> observables = new HashSet<ObservableId>();
    private final Set<MarketDataId<?>> nonObservables = new HashSet();
    private final Set<ObservableId> timeSeries = new HashSet<ObservableId>();
    private final Set<Currency> outputCurrencies = new HashSet<Currency>();

    public MarketDataRequirementsBuilder addTimeSeries(Collection<? extends ObservableId> ids) {
        ArgChecker.notNull(ids, (String)"ids");
        this.timeSeries.addAll(ids);
        return this;
    }

    public MarketDataRequirementsBuilder addTimeSeries(ObservableId ... ids) {
        return this.addTimeSeries(Arrays.asList(ids));
    }

    public MarketDataRequirementsBuilder addValues(Collection<? extends MarketDataId<?>> ids) {
        ArgChecker.notNull(ids, (String)"ids");
        for (MarketDataId<?> id : ids) {
            if (id instanceof ObservableId) {
                this.observables.add((ObservableId)id);
                continue;
            }
            this.nonObservables.add(id);
        }
        return this;
    }

    public MarketDataRequirementsBuilder addValues(MarketDataId<?> ... ids) {
        return this.addValues(Arrays.asList(ids));
    }

    public MarketDataRequirementsBuilder addOutputCurrencies(Currency ... currencies) {
        this.outputCurrencies.addAll(Arrays.asList(currencies));
        return this;
    }

    public MarketDataRequirementsBuilder addRequirements(MarketDataRequirements requirements) {
        ArgChecker.notNull((Object)requirements, (String)"requirements");
        this.observables.addAll((Collection<ObservableId>)requirements.getObservables());
        this.outputCurrencies.addAll((Collection<Currency>)requirements.getOutputCurrencies());
        this.nonObservables.addAll((Collection<MarketDataId<?>>)requirements.getNonObservables());
        this.timeSeries.addAll((Collection<ObservableId>)requirements.getTimeSeries());
        return this;
    }

    public MarketDataRequirements build() {
        return new MarketDataRequirements(this.observables, this.nonObservables, this.timeSeries, this.outputCurrencies);
    }
}

