/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataNode;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DependencyTreeBuilder {
    private final ScenarioMarketData suppliedData;
    private final Map<Class<? extends MarketDataId<?>>, MarketDataFunction<?, ?>> functions;
    private final MarketDataRequirements requirements;
    private final MarketDataConfig marketDataConfig;

    static DependencyTreeBuilder of(ScenarioMarketData suppliedData, MarketDataRequirements requirements, MarketDataConfig marketDataConfig, Map<Class<? extends MarketDataId<?>>, MarketDataFunction<?, ?>> functions) {
        return new DependencyTreeBuilder(suppliedData, requirements, marketDataConfig, functions);
    }

    private DependencyTreeBuilder(ScenarioMarketData suppliedData, MarketDataRequirements requirements, MarketDataConfig marketDataConfig, Map<Class<? extends MarketDataId<?>>, MarketDataFunction<?, ?>> functions) {
        this.suppliedData = suppliedData;
        this.requirements = requirements;
        this.marketDataConfig = marketDataConfig;
        this.functions = functions;
    }

    List<MarketDataNode> dependencyNodes() {
        return this.dependencyNodes(this.requirements);
    }

    private List<MarketDataNode> dependencyNodes(MarketDataRequirements requirements) {
        List<MarketDataNode> observableNodes = this.buildNodes((Set<? extends MarketDataId<?>>)requirements.getObservables(), MarketDataNode.DataType.SINGLE_VALUE);
        List<MarketDataNode> nonObservableNodes = this.buildNodes((Set<? extends MarketDataId<?>>)requirements.getNonObservables(), MarketDataNode.DataType.SINGLE_VALUE);
        List<MarketDataNode> timeSeriesNodes = this.buildNodes((Set<? extends MarketDataId<?>>)requirements.getTimeSeries(), MarketDataNode.DataType.TIME_SERIES);
        return ImmutableList.builder().addAll(observableNodes).addAll(nonObservableNodes).addAll(timeSeriesNodes).build();
    }

    private List<MarketDataNode> buildNodes(Set<? extends MarketDataId<?>> ids, MarketDataNode.DataType dataType) {
        return (List)ids.stream().map(id -> this.buildNode((MarketDataId<?>)id, dataType)).collect(Guavate.toImmutableList());
    }

    private MarketDataNode buildNode(MarketDataId<?> id, MarketDataNode.DataType dataType) {
        if (id instanceof ObservableId || DependencyTreeBuilder.isSupplied(id, dataType, this.suppliedData)) {
            return MarketDataNode.leaf(id, dataType);
        }
        MarketDataFunction<?, ?> function = this.functions.get(id.getClass());
        if (function != null) {
            try {
                MarketDataRequirements requirements = function.requirements(id, this.marketDataConfig);
                return MarketDataNode.child(id, dataType, this.dependencyNodes(requirements));
            }
            catch (Exception e) {
                return MarketDataNode.child(id, dataType, (List<MarketDataNode>)ImmutableList.of());
            }
        }
        return MarketDataNode.leaf(id, dataType);
    }

    private static boolean isSupplied(MarketDataId<?> id, MarketDataNode.DataType dataType, ScenarioMarketData suppliedData) {
        switch (dataType) {
            case TIME_SERIES: {
                return id instanceof ObservableId && !suppliedData.getTimeSeries((ObservableId)id).isEmpty();
            }
            case SINGLE_VALUE: {
                return suppliedData.containsValue(id);
            }
        }
        throw new IllegalArgumentException("Unexpected data type " + (Object)((Object)dataType));
    }
}

