/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.opengamma.strata.calc.marketdata.BuiltScenarioMarketData;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Failure;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketData;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketDataBuilder;
import com.opengamma.strata.data.scenario.MarketDataBox;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

final class BuiltScenarioMarketDataBuilder {
    private MarketDataBox<LocalDate> valuationDate = MarketDataBox.empty();
    private int scenarioCount;
    private final Map<MarketDataId<?>, MarketDataBox<?>> values = new HashMap();
    private final Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries = new HashMap<ObservableId, LocalDateDoubleTimeSeries>();
    private final Map<MarketDataId<?>, Failure> valueFailures = new HashMap();
    private final Map<MarketDataId<?>, Failure> timeSeriesFailures = new HashMap();

    BuiltScenarioMarketDataBuilder(LocalDate valuationDate) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        this.valuationDate = MarketDataBox.ofSingleValue((Object)valuationDate);
        this.updateScenarioCount(this.valuationDate);
    }

    BuiltScenarioMarketDataBuilder(MarketDataBox<LocalDate> valuationDate) {
        ArgChecker.notNull(valuationDate, (String)"valuationDate");
        if (valuationDate.getScenarioCount() == 0) {
            throw new IllegalArgumentException("Valuation date must not be empty");
        }
        this.updateScenarioCount(valuationDate);
        this.valuationDate = valuationDate;
    }

    BuiltScenarioMarketDataBuilder(MarketDataBox<LocalDate> valuationDate, int scenarioCount, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries, Map<MarketDataId<?>, Failure> valueFailures, Map<MarketDataId<?>, Failure> timeSeriesFailures) {
        this.valuationDate = (MarketDataBox)ArgChecker.notNull(valuationDate, (String)"valuationDate");
        this.scenarioCount = scenarioCount;
        this.values.putAll(values);
        this.timeSeries.putAll(timeSeries);
        this.valueFailures.putAll(valueFailures);
        this.timeSeriesFailures.putAll(timeSeriesFailures);
    }

    <T> BuiltScenarioMarketDataBuilder addValue(MarketDataId<T> id, T value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(value, (String)"value");
        this.values.put(id, MarketDataBox.ofSingleValue(value));
        return this;
    }

    BuiltScenarioMarketDataBuilder addBox(MarketDataId<?> id, MarketDataBox<?> box) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(box, (String)"box");
        this.updateScenarioCount(box);
        BuiltScenarioMarketDataBuilder.checkBoxType(id, box);
        this.values.put(id, box);
        return this;
    }

    <T> BuiltScenarioMarketDataBuilder addResult(MarketDataId<T> id, Result<MarketDataBox<?>> result) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(result, (String)"result");
        if (result.isSuccess()) {
            MarketDataBox box = (MarketDataBox)result.getValue();
            BuiltScenarioMarketDataBuilder.checkBoxType(id, box);
            this.updateScenarioCount(box);
            this.values.put(id, box);
            this.valueFailures.remove(id);
        } else {
            this.valueFailures.put(id, result.getFailure());
            this.values.remove(id);
        }
        return this;
    }

    BuiltScenarioMarketDataBuilder addTimeSeries(ObservableId id, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)id, (String)"id");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.timeSeries.put(id, timeSeries);
        return this;
    }

    BuiltScenarioMarketDataBuilder addTimeSeriesResult(ObservableId id, Result<LocalDateDoubleTimeSeries> result) {
        ArgChecker.notNull((Object)id, (String)"id");
        ArgChecker.notNull(result, (String)"result");
        if (result.isSuccess()) {
            this.timeSeries.put(id, (LocalDateDoubleTimeSeries)result.getValue());
            this.timeSeriesFailures.remove(id);
        } else {
            this.timeSeriesFailures.put((MarketDataId<?>)id, result.getFailure());
            this.timeSeries.remove(id);
        }
        return this;
    }

    BuiltScenarioMarketData build() {
        if (this.valuationDate.getScenarioCount() == 0) {
            throw new IllegalArgumentException("Valuation date must be specified");
        }
        ImmutableScenarioMarketDataBuilder builder = ImmutableScenarioMarketData.builder(this.valuationDate).addBoxMap(this.values).addTimeSeriesMap(this.timeSeries);
        return new BuiltScenarioMarketData(builder.build(), this.valueFailures, this.timeSeriesFailures);
    }

    private static void checkBoxType(MarketDataId<?> id, MarketDataBox<?> box) {
        if (!id.getMarketDataType().isAssignableFrom(box.getMarketDataType())) {
            throw new IllegalArgumentException(Messages.format((String)"Market data type {} of value {} is not compatible with the market data type of the identifier {}", (Object[])new Object[]{box.getMarketDataType().getName(), box, id.getMarketDataType().getName()}));
        }
    }

    private void updateScenarioCount(MarketDataBox<?> box) {
        if (box.isSingleValue()) {
            if (this.scenarioCount == 0) {
                this.scenarioCount = 1;
            }
            return;
        }
        int scenarioCount = box.getScenarioCount();
        if (this.scenarioCount == 0 || this.scenarioCount == 1) {
            this.scenarioCount = scenarioCount;
            return;
        }
        if (scenarioCount != this.scenarioCount) {
            throw new IllegalArgumentException(Messages.format((String)"All values must have the same number of scenarios, expecting {} but received {}", (Object[])new Object[]{this.scenarioCount, scenarioCount}));
        }
    }
}

