/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.calc.marketdata.BuiltScenarioMarketData;
import com.opengamma.strata.collect.result.Failure;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.ObservableId;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class BuiltMarketData
implements MarketData,
ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final BuiltScenarioMarketData underlying;

    public LocalDate getValuationDate() {
        return (LocalDate)this.underlying.getValuationDate().getSingleValue();
    }

    public boolean containsValue(MarketDataId<?> id) {
        return this.underlying.containsValue(id);
    }

    public <T> T getValue(MarketDataId<T> id) {
        return (T)this.underlying.getValue(id).getSingleValue();
    }

    public <T> Optional<T> findValue(MarketDataId<T> id) {
        return this.underlying.findValue(id).map(v -> v.getSingleValue());
    }

    public Set<MarketDataId<?>> getIds() {
        return this.underlying.getIds();
    }

    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return this.underlying.findIds(name);
    }

    public Set<ObservableId> getTimeSeriesIds() {
        return this.underlying.getTimeSeriesIds();
    }

    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        return this.underlying.getTimeSeries(id);
    }

    public ImmutableMap<MarketDataId<?>, Failure> getValueFailures() {
        return this.underlying.getValueFailures();
    }

    public ImmutableMap<MarketDataId<?>, Failure> getTimeSeriesFailures() {
        return this.underlying.getTimeSeriesFailures();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    BuiltMarketData(BuiltScenarioMarketData underlying) {
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuiltScenarioMarketData getUnderlying() {
        return this.underlying;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BuiltMarketData other = (BuiltMarketData)obj;
            return JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("BuiltMarketData{");
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<BuiltMarketData> {
        private BuiltScenarioMarketData underlying;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    this.underlying = (BuiltScenarioMarketData)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public BuiltMarketData build() {
            return new BuiltMarketData(this.underlying);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("BuiltMarketData.Builder{");
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuiltScenarioMarketData> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", BuiltMarketData.class, BuiltScenarioMarketData.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends BuiltMarketData> builder() {
            return new Builder();
        }

        public Class<? extends BuiltMarketData> beanType() {
            return BuiltMarketData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuiltScenarioMarketData> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return ((BuiltMarketData)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

