/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueAdjustment;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ValueStep
implements ImmutableBean,
Serializable {
    @PropertyDefinition(get="optional")
    private final Integer periodIndex;
    @PropertyDefinition(get="optional")
    private final LocalDate date;
    @PropertyDefinition(validate="notNull")
    private final ValueAdjustment value;
    private static final long serialVersionUID = 1L;

    public static ValueStep of(int periodIndex, ValueAdjustment value) {
        return new ValueStep(periodIndex, null, value);
    }

    public static ValueStep of(LocalDate date, ValueAdjustment value) {
        return new ValueStep(null, date, value);
    }

    int findIndex(List<SchedulePeriod> periods) {
        SchedulePeriod period;
        int i;
        if (this.periodIndex != null) {
            if (this.periodIndex >= periods.size()) {
                throw new IllegalArgumentException("ValueStep index is beyond last schedule period");
            }
            return this.periodIndex;
        }
        for (i = 0; i < periods.size(); ++i) {
            period = periods.get(i);
            if (!period.getUnadjustedStartDate().equals(this.date)) continue;
            return i;
        }
        for (i = 0; i < periods.size(); ++i) {
            period = periods.get(i);
            if (!period.getStartDate().equals(this.date)) continue;
            return i;
        }
        return -1;
    }

    int findPreviousIndex(List<SchedulePeriod> periods) {
        SchedulePeriod firstPeriod = periods.get(0);
        if (this.date.isBefore(firstPeriod.getUnadjustedStartDate())) {
            throw new IllegalArgumentException("ValueStep date is before the start of the schedule: " + this.date + " < " + firstPeriod.getUnadjustedStartDate());
        }
        for (int i = 1; i < periods.size(); ++i) {
            SchedulePeriod period = periods.get(i);
            if (!period.getUnadjustedStartDate().isAfter(this.date)) continue;
            return i - 1;
        }
        SchedulePeriod lastPeriod = periods.get(periods.size() - 1);
        if (this.date.isAfter(lastPeriod.getUnadjustedEndDate())) {
            throw new IllegalArgumentException("ValueStep date is after the end of the schedule: " + this.date + " > " + lastPeriod.getUnadjustedEndDate());
        }
        return periods.size() - 1;
    }

    @ImmutableValidator
    private void validate() {
        if (this.periodIndex == null && this.date == null) {
            throw new IllegalArgumentException("Either the 'periodIndex' or 'date' must be set");
        }
        if (this.periodIndex != null) {
            if (this.date != null) {
                throw new IllegalArgumentException("Either the 'periodIndex' or 'date' must be set, not both");
            }
            if (this.periodIndex < 1) {
                throw new IllegalArgumentException("The 'periodIndex' must not be zero or negative");
            }
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValueStep(Integer periodIndex, LocalDate date, ValueAdjustment value) {
        JodaBeanUtils.notNull((Object)value, (String)"value");
        this.periodIndex = periodIndex;
        this.date = date;
        this.value = value;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OptionalInt getPeriodIndex() {
        return this.periodIndex != null ? OptionalInt.of(this.periodIndex) : OptionalInt.empty();
    }

    public Optional<LocalDate> getDate() {
        return Optional.ofNullable(this.date);
    }

    public ValueAdjustment getValue() {
        return this.value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueStep other = (ValueStep)obj;
            return JodaBeanUtils.equal((Object)this.periodIndex, (Object)other.periodIndex) && JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodIndex);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ValueStep{");
        buf.append("periodIndex").append('=').append(JodaBeanUtils.toString((Object)this.periodIndex)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ValueStep> {
        private Integer periodIndex;
        private LocalDate date;
        private ValueAdjustment value;

        private Builder() {
        }

        private Builder(ValueStep beanToCopy) {
            this.periodIndex = beanToCopy.periodIndex;
            this.date = beanToCopy.date;
            this.value = beanToCopy.getValue();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -980601967: {
                    return this.periodIndex;
                }
                case 3076014: {
                    return this.date;
                }
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -980601967: {
                    this.periodIndex = (Integer)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (LocalDate)newValue;
                    break;
                }
                case 111972721: {
                    this.value = (ValueAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ValueStep build() {
            return new ValueStep(this.periodIndex, this.date, this.value);
        }

        public Builder periodIndex(Integer periodIndex) {
            this.periodIndex = periodIndex;
            return this;
        }

        public Builder date(LocalDate date) {
            this.date = date;
            return this;
        }

        public Builder value(ValueAdjustment value) {
            JodaBeanUtils.notNull((Object)value, (String)"value");
            this.value = value;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ValueStep.Builder{");
            buf.append("periodIndex").append('=').append(JodaBeanUtils.toString((Object)this.periodIndex)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> periodIndex = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodIndex", ValueStep.class, Integer.class);
        private final MetaProperty<LocalDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", ValueStep.class, LocalDate.class);
        private final MetaProperty<ValueAdjustment> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", ValueStep.class, ValueAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"periodIndex", "date", "value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -980601967: {
                    return this.periodIndex;
                }
                case 3076014: {
                    return this.date;
                }
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ValueStep> beanType() {
            return ValueStep.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> periodIndex() {
            return this.periodIndex;
        }

        public MetaProperty<LocalDate> date() {
            return this.date;
        }

        public MetaProperty<ValueAdjustment> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -980601967: {
                    return ((ValueStep)bean).periodIndex;
                }
                case 3076014: {
                    return ((ValueStep)bean).date;
                }
                case 111972721: {
                    return ((ValueStep)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

