/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.HalfUpRounding;
import com.opengamma.strata.basics.value.NoRounding;
import com.opengamma.strata.collect.Decimal;
import java.math.BigDecimal;

public interface Rounding {
    public static Rounding none() {
        return NoRounding.INSTANCE;
    }

    public static Rounding of(Currency currency) {
        return HalfUpRounding.ofDecimalPlaces(currency.getMinorUnitDigits());
    }

    public static Rounding ofDecimalPlaces(int decimalPlaces) {
        return HalfUpRounding.ofDecimalPlaces(decimalPlaces);
    }

    public static Rounding ofFractionalDecimalPlaces(int decimalPlaces, int fraction) {
        return HalfUpRounding.ofFractionalDecimalPlaces(decimalPlaces, fraction);
    }

    default public double round(double value) {
        return this.round(BigDecimal.valueOf(value)).doubleValue();
    }

    public BigDecimal round(BigDecimal var1);

    default public Decimal round(Decimal value) {
        return Decimal.of((BigDecimal)this.round(value.toBigDecimal()));
    }
}

