/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.HolidayCalendars;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.collect.ArgChecker;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;

enum StandardRollConventions implements RollConvention
{
    NONE("None"){

        @Override
        public LocalDate adjust(LocalDate date) {
            return (LocalDate)ArgChecker.notNull((Object)date, (String)"date");
        }
    }
    ,
    EOM("EOM"){

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.withDayOfMonth(date.lengthOfMonth());
        }

        @Override
        public int getDayOfMonth() {
            return 31;
        }
    }
    ,
    IMM("IMM"){

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.WEDNESDAY));
        }
    }
    ,
    IMMCAD("IMMCAD"){
        private final HolidayCalendar gblo = StandardRollConventions.access$100(HolidayCalendarIds.GBLO);
        private final HolidayCalendar canada = StandardRollConventions.access$100(HolidayCalendarIds.CATO).combinedWith(StandardRollConventions.access$100(HolidayCalendarIds.CAMO));

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            LocalDate wed3 = date.with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.WEDNESDAY));
            return this.canada.previousOrSame(this.gblo.shift(wed3, -2));
        }
    }
    ,
    IMMAUD("IMMAUD"){
        private final HolidayCalendar ausy = StandardRollConventions.access$100(HolidayCalendarIds.AUSY);

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return this.ausy.previous(date.with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.FRIDAY)));
        }
    }
    ,
    IMMNZD("IMMNZD"){

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.withDayOfMonth(9).with(TemporalAdjusters.nextOrSame(DayOfWeek.WEDNESDAY));
        }
    }
    ,
    SFE("SFE"){

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.FRIDAY));
        }
    }
    ,
    TBILL("TBILL"){
        private final HolidayCalendar usny = StandardRollConventions.access$100(HolidayCalendarIds.USNY);

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return this.usny.nextOrSame(date.with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY)));
        }
    };

    private final String name;

    private StandardRollConventions(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    private static HolidayCalendar holidayCalendar(HolidayCalendarId id) {
        return ReferenceData.standard().findValue(id).orElse(HolidayCalendars.SAT_SUN);
    }

    static /* synthetic */ HolidayCalendar access$100(HolidayCalendarId x0) {
        return StandardRollConventions.holidayCalendar(x0);
    }
}

