/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.ScheduleException;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.tuple.Pair;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Schedule
implements DayCount.ScheduleInfo,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<SchedulePeriod> periods;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final RollConvention rollConvention;
    private static final long serialVersionUID = 1L;

    public static Schedule ofTerm(SchedulePeriod period) {
        ArgChecker.notNull((Object)period, (String)"period");
        return Schedule.builder().periods((List<SchedulePeriod>)ImmutableList.of((Object)period)).frequency(Frequency.TERM).rollConvention(RollConventions.NONE).build();
    }

    public int size() {
        return this.periods.size();
    }

    public boolean isTerm() {
        return this.size() == 1 && this.frequency.equals(Frequency.TERM);
    }

    public boolean isSinglePeriod() {
        return this.size() == 1;
    }

    public SchedulePeriod getPeriod(int index) {
        return (SchedulePeriod)this.periods.get(index);
    }

    public SchedulePeriod getFirstPeriod() {
        return (SchedulePeriod)this.periods.get(0);
    }

    public SchedulePeriod getLastPeriod() {
        return (SchedulePeriod)this.periods.get(this.periods.size() - 1);
    }

    @Override
    public LocalDate getStartDate() {
        return this.getFirstPeriod().getStartDate();
    }

    @Override
    public LocalDate getEndDate() {
        return this.getLastPeriod().getEndDate();
    }

    public LocalDate getUnadjustedStartDate() {
        return this.getFirstPeriod().getUnadjustedStartDate();
    }

    public LocalDate getUnadjustedEndDate() {
        return this.getLastPeriod().getUnadjustedEndDate();
    }

    public Optional<SchedulePeriod> getInitialStub() {
        return this.isInitialStub() ? Optional.of(this.getFirstPeriod()) : Optional.empty();
    }

    private boolean isInitialStub() {
        return !this.isTerm() && !this.getFirstPeriod().isRegular(this.frequency, this.rollConvention);
    }

    public Optional<SchedulePeriod> getFinalStub() {
        return this.isFinalStub() ? Optional.of(this.getLastPeriod()) : Optional.empty();
    }

    private boolean isFinalStub() {
        return !this.isSinglePeriod() && !this.getLastPeriod().isRegular(this.frequency, this.rollConvention);
    }

    public Pair<Optional<SchedulePeriod>, Optional<SchedulePeriod>> getStubs(boolean preferFinal) {
        Optional<SchedulePeriod> initialStub = this.getInitialStub();
        if (preferFinal && this.size() == 1 && initialStub.isPresent()) {
            return Pair.of(Optional.empty(), initialStub);
        }
        return Pair.of(initialStub, this.getFinalStub());
    }

    public ImmutableList<SchedulePeriod> getRegularPeriods() {
        if (this.isTerm()) {
            return this.periods;
        }
        int startStub = this.isInitialStub() ? 1 : 0;
        int endStub = this.isFinalStub() ? 1 : 0;
        return startStub == 0 && endStub == 0 ? this.periods : this.periods.subList(startStub, this.periods.size() - endStub);
    }

    public ImmutableList<LocalDate> getUnadjustedDates() {
        ImmutableList.Builder dates = ImmutableList.builder();
        dates.add((Object)this.getUnadjustedStartDate());
        for (SchedulePeriod period : this.periods) {
            dates.add((Object)period.getUnadjustedEndDate());
        }
        return dates.build();
    }

    @Override
    public boolean isEndOfMonthConvention() {
        return this.rollConvention == RollConventions.EOM;
    }

    @Override
    public LocalDate getPeriodEndDate(LocalDate date) {
        return this.periods.stream().filter(p -> p.contains(date)).map(p -> p.getEndDate()).findFirst().orElseThrow(() -> new IllegalArgumentException("Date is not contained in any period"));
    }

    public Schedule mergeToTerm() {
        if (this.isTerm()) {
            return this;
        }
        SchedulePeriod first = this.getFirstPeriod();
        SchedulePeriod last = this.getLastPeriod();
        return Schedule.ofTerm(SchedulePeriod.of(first.getStartDate(), last.getEndDate(), first.getUnadjustedStartDate(), last.getUnadjustedEndDate()));
    }

    public Schedule merge(int groupSize, LocalDate firstRegularStartDate, LocalDate lastRegularEndDate) {
        ArgChecker.notNegativeOrZero((int)groupSize, (String)"groupSize");
        ArgChecker.inOrderOrEqual((Comparable)firstRegularStartDate, (Object)lastRegularEndDate, (String)"firstRegularStartDate", (String)"lastRegularEndDate");
        if (this.isSinglePeriod() || groupSize == 1) {
            return this;
        }
        int startRegularIndex = -1;
        int endRegularIndex = -1;
        for (int i = 0; i < this.size(); ++i) {
            SchedulePeriod period = (SchedulePeriod)this.periods.get(i);
            if (period.getUnadjustedStartDate().equals(firstRegularStartDate) || period.getStartDate().equals(firstRegularStartDate)) {
                startRegularIndex = i;
            }
            if (!period.getUnadjustedEndDate().equals(lastRegularEndDate) && !period.getEndDate().equals(lastRegularEndDate)) continue;
            endRegularIndex = i + 1;
        }
        if (startRegularIndex < 0) {
            throw new ScheduleException("Unable to merge schedule, firstRegularStartDate {} does not match any date in the underlying schedule {}", firstRegularStartDate, this.getUnadjustedDates());
        }
        if (endRegularIndex < 0) {
            throw new ScheduleException("Unable to merge schedule, lastRegularEndDate {} does not match any date in the underlying schedule {}", lastRegularEndDate, this.getUnadjustedDates());
        }
        int numberRegular = endRegularIndex - startRegularIndex;
        if (numberRegular % groupSize != 0) {
            Period newFrequency = this.frequency.getPeriod().multipliedBy(groupSize);
            throw new ScheduleException("Unable to merge schedule, firstRegularStartDate {} and lastRegularEndDate {} cannot be used to create regular periods of frequency '{}'", firstRegularStartDate, lastRegularEndDate, newFrequency);
        }
        ArrayList<SchedulePeriod> newSchedule = new ArrayList<SchedulePeriod>();
        if (startRegularIndex > 0) {
            newSchedule.add(this.createSchedulePeriod((List<SchedulePeriod>)this.periods.subList(0, startRegularIndex)));
        }
        for (int i = startRegularIndex; i < endRegularIndex; i += groupSize) {
            newSchedule.add(this.createSchedulePeriod((List<SchedulePeriod>)this.periods.subList(i, i + groupSize)));
        }
        if (endRegularIndex < this.periods.size()) {
            newSchedule.add(this.createSchedulePeriod((List<SchedulePeriod>)this.periods.subList(endRegularIndex, this.periods.size())));
        }
        return Schedule.builder().periods(newSchedule).frequency(Frequency.of(this.frequency.getPeriod().multipliedBy(groupSize))).rollConvention(this.rollConvention).build();
    }

    public Schedule mergeRegular(int groupSize, boolean rollForwards) {
        int startIndex;
        ArgChecker.notNegativeOrZero((int)groupSize, (String)"groupSize");
        if (this.isSinglePeriod() || groupSize == 1) {
            return this;
        }
        ArrayList<SchedulePeriod> newSchedule = new ArrayList<SchedulePeriod>();
        Optional<SchedulePeriod> initialStub = this.getInitialStub();
        if (initialStub.isPresent()) {
            newSchedule.add(initialStub.get());
        }
        ImmutableList<SchedulePeriod> regularPeriods = this.getRegularPeriods();
        int regularSize = regularPeriods.size();
        int remainder = regularSize % groupSize;
        for (int i = startIndex = rollForwards || remainder == 0 ? 0 : -(groupSize - remainder); i < regularSize; i += groupSize) {
            int from = Math.max(i, 0);
            int to = Math.min(i + groupSize, regularSize);
            newSchedule.add(this.createSchedulePeriod((List<SchedulePeriod>)regularPeriods.subList(from, to)));
        }
        Optional<SchedulePeriod> finalStub = this.getFinalStub();
        if (finalStub.isPresent()) {
            newSchedule.add(finalStub.get());
        }
        return Schedule.builder().periods(newSchedule).frequency(Frequency.of(this.frequency.getPeriod().multipliedBy(groupSize))).rollConvention(this.rollConvention).build();
    }

    private SchedulePeriod createSchedulePeriod(List<SchedulePeriod> accruals) {
        SchedulePeriod first = accruals.get(0);
        if (accruals.size() == 1) {
            return first;
        }
        SchedulePeriod last = accruals.get(accruals.size() - 1);
        return SchedulePeriod.of(first.getStartDate(), last.getEndDate(), first.getUnadjustedStartDate(), last.getUnadjustedEndDate());
    }

    public Schedule toAdjusted(DateAdjuster adjuster) {
        boolean adjusted = false;
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = this.periods.size();
        for (int i = 0; i < size; ++i) {
            SchedulePeriod period = (SchedulePeriod)this.periods.get(i);
            int mergeType = i == 0 ? -1 : (i == size - 1 ? 1 : 0);
            SchedulePeriod adjPeriod = period.toAdjusted(adjuster, mergeType);
            builder.add((Object)adjPeriod);
            adjusted |= adjPeriod != period;
        }
        return adjusted ? new Schedule((List<SchedulePeriod>)builder.build(), this.frequency, this.rollConvention) : this;
    }

    public Schedule toUnadjusted() {
        return this.toBuilder().periods((List)this.periods.stream().map(p -> p.toUnadjusted()).collect(Guavate.toImmutableList())).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Schedule(List<SchedulePeriod> periods, Frequency frequency, RollConvention rollConvention) {
        JodaBeanUtils.notEmpty(periods, (String)"periods");
        JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
        JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
        this.periods = ImmutableList.copyOf(periods);
        this.frequency = frequency;
        this.rollConvention = rollConvention;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<SchedulePeriod> getPeriods() {
        return this.periods;
    }

    @Override
    public Frequency getFrequency() {
        return this.frequency;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Schedule other = (Schedule)obj;
            return JodaBeanUtils.equal(this.periods, other.periods) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.periods);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Schedule{");
        buf.append("periods").append('=').append(JodaBeanUtils.toString(this.periods)).append(',').append(' ');
        buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
        buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Schedule> {
        private List<SchedulePeriod> periods = ImmutableList.of();
        private Frequency frequency;
        private RollConvention rollConvention;

        private Builder() {
        }

        private Builder(Schedule beanToCopy) {
            this.periods = beanToCopy.getPeriods();
            this.frequency = beanToCopy.getFrequency();
            this.rollConvention = beanToCopy.getRollConvention();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -678739246: {
                    return this.periods;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -678739246: {
                    this.periods = (List)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Schedule build() {
            return new Schedule(this.periods, this.frequency, this.rollConvention);
        }

        public Builder periods(List<SchedulePeriod> periods) {
            JodaBeanUtils.notEmpty(periods, (String)"periods");
            this.periods = periods;
            return this;
        }

        public Builder periods(SchedulePeriod ... periods) {
            return this.periods((List<SchedulePeriod>)ImmutableList.copyOf((Object[])periods));
        }

        public Builder frequency(Frequency frequency) {
            JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
            this.frequency = frequency;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
            this.rollConvention = rollConvention;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Schedule.Builder{");
            buf.append("periods").append('=').append(JodaBeanUtils.toString(this.periods)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<SchedulePeriod>> periods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periods", Schedule.class, ImmutableList.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", Schedule.class, Frequency.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", Schedule.class, RollConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"periods", "frequency", "rollConvention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -678739246: {
                    return this.periods;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Schedule> beanType() {
            return Schedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<SchedulePeriod>> periods() {
            return this.periods;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -678739246: {
                    return ((Schedule)bean).getPeriods();
                }
                case -70023844: {
                    return ((Schedule)bean).getFrequency();
                }
                case -10223666: {
                    return ((Schedule)bean).getRollConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

