/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IndexObservation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class IborIndexObservation
implements IndexObservation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final LocalDate fixingDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate effectiveDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate maturityDate;
    @PropertyDefinition(validate="notNull")
    private final double yearFraction;
    private static final long serialVersionUID = 1L;

    public static IborIndexObservation of(IborIndex index, LocalDate fixingDate, ReferenceData refData) {
        LocalDate effectiveDate = index.calculateEffectiveFromFixing(fixingDate, refData);
        LocalDate maturityDate = index.calculateMaturityFromEffective(effectiveDate, refData);
        double yearFraction = index.getDayCount().yearFraction(effectiveDate, maturityDate);
        return new IborIndexObservation(index, fixingDate, effectiveDate, maturityDate, yearFraction);
    }

    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    IborIndexObservation(IborIndex index, LocalDate fixingDate, LocalDate effectiveDate, LocalDate maturityDate, double yearFraction) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
        JodaBeanUtils.notNull((Object)effectiveDate, (String)"effectiveDate");
        JodaBeanUtils.notNull((Object)maturityDate, (String)"maturityDate");
        JodaBeanUtils.notNull((Object)yearFraction, (String)"yearFraction");
        this.index = index;
        this.fixingDate = fixingDate;
        this.effectiveDate = effectiveDate;
        this.maturityDate = maturityDate;
        this.yearFraction = yearFraction;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public LocalDate getFixingDate() {
        return this.fixingDate;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborIndexObservation other = (IborIndexObservation)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fixingDate, (Object)other.fixingDate) && JodaBeanUtils.equal((Object)this.effectiveDate, (Object)other.effectiveDate) && JodaBeanUtils.equal((Object)this.maturityDate, (Object)other.maturityDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.effectiveDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.maturityDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("IborIndexObservation{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
        buf.append("effectiveDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveDate)).append(',').append(' ');
        buf.append("maturityDate").append('=').append(JodaBeanUtils.toString((Object)this.maturityDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborIndexObservation> {
        private IborIndex index;
        private LocalDate fixingDate;
        private LocalDate effectiveDate;
        private LocalDate maturityDate;
        private double yearFraction;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -930389515: {
                    return this.effectiveDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1255202043: {
                    this.fixingDate = (LocalDate)newValue;
                    break;
                }
                case -930389515: {
                    this.effectiveDate = (LocalDate)newValue;
                    break;
                }
                case -414641441: {
                    this.maturityDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborIndexObservation build() {
            return new IborIndexObservation(this.index, this.fixingDate, this.effectiveDate, this.maturityDate, this.yearFraction);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("IborIndexObservation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
            buf.append("effectiveDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveDate)).append(',').append(' ');
            buf.append("maturityDate").append('=').append(JodaBeanUtils.toString((Object)this.maturityDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborIndexObservation.class, IborIndex.class);
        private final MetaProperty<LocalDate> fixingDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDate", IborIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> effectiveDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveDate", IborIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> maturityDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maturityDate", IborIndexObservation.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", IborIndexObservation.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fixingDate", "effectiveDate", "maturityDate", "yearFraction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -930389515: {
                    return this.effectiveDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborIndexObservation> builder() {
            return new Builder();
        }

        public Class<? extends IborIndexObservation> beanType() {
            return IborIndexObservation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> fixingDate() {
            return this.fixingDate;
        }

        public MetaProperty<LocalDate> effectiveDate() {
            return this.effectiveDate;
        }

        public MetaProperty<LocalDate> maturityDate() {
            return this.maturityDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((IborIndexObservation)bean).getIndex();
                }
                case 1255202043: {
                    return ((IborIndexObservation)bean).getFixingDate();
                }
                case -930389515: {
                    return ((IborIndexObservation)bean).getEffectiveDate();
                }
                case -414641441: {
                    return ((IborIndexObservation)bean).getMaturityDate();
                }
                case -1731780257: {
                    return ((IborIndexObservation)bean).getYearFraction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

