/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.index.FloatingRate;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.Indices;
import com.opengamma.strata.collect.ArgChecker;
import java.util.Optional;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FloatingRateIndex
extends Index,
FloatingRate {
    public static FloatingRateIndex parse(String indexStr) {
        return FloatingRateIndex.parse(indexStr, null);
    }

    public static FloatingRateIndex parse(String indexStr, Tenor defaultIborTenor) {
        ArgChecker.notNull((Object)indexStr, (String)"indexStr");
        return FloatingRateIndex.tryParse(indexStr, defaultIborTenor).orElseThrow(() -> new IllegalArgumentException("Floating rate index not known: " + indexStr));
    }

    public static Optional<FloatingRateIndex> tryParse(String indexStr) {
        return FloatingRateIndex.tryParse(indexStr, null);
    }

    public static Optional<FloatingRateIndex> tryParse(String indexStr, Tenor defaultIborTenor) {
        return FloatingRate.tryParse(indexStr).map(fr -> {
            if (fr instanceof FloatingRateName) {
                FloatingRateName frName = (FloatingRateName)fr;
                return frName.toFloatingRateIndex(defaultIborTenor != null ? defaultIborTenor : frName.getDefaultTenor());
            }
            return (FloatingRateIndex)fr;
        });
    }

    @FromString
    public static FloatingRateIndex of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FloatingRateIndex)Indices.FLOATING_RATE_INDEX_LOOKUP.lookup(uniqueName);
    }

    @Override
    @ToString
    public String getName();

    @Override
    public Currency getCurrency();

    public boolean isActive();

    public DayCount getDayCount();

    @Override
    public FloatingRateName getFloatingRateName();

    default public DayCount getDefaultFixedLegDayCount() {
        return this.getDayCount();
    }
}

