/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.PeriodAdditionConvention;
import com.opengamma.strata.collect.ArgChecker;
import java.time.LocalDate;
import java.time.Period;

enum StandardPeriodAdditionConventions implements PeriodAdditionConvention
{
    NONE("None"){

        @Override
        public LocalDate adjust(LocalDate baseDate, Period period, HolidayCalendar calendar) {
            ArgChecker.notNull((Object)baseDate, (String)"baseDate");
            ArgChecker.notNull((Object)period, (String)"period");
            ArgChecker.notNull((Object)calendar, (String)"calendar");
            return baseDate.plus(period);
        }

        @Override
        public boolean isMonthBased() {
            return false;
        }
    }
    ,
    LAST_DAY("LastDay"){

        @Override
        public LocalDate adjust(LocalDate baseDate, Period period, HolidayCalendar calendar) {
            ArgChecker.notNull((Object)baseDate, (String)"baseDate");
            ArgChecker.notNull((Object)period, (String)"period");
            ArgChecker.notNull((Object)calendar, (String)"calendar");
            LocalDate endDate = baseDate.plus(period);
            if (baseDate.getDayOfMonth() == baseDate.lengthOfMonth()) {
                return endDate.withDayOfMonth(endDate.lengthOfMonth());
            }
            return endDate;
        }

        @Override
        public boolean isMonthBased() {
            return true;
        }
    }
    ,
    LAST_BUSINESS_DAY("LastBusinessDay"){

        @Override
        public LocalDate adjust(LocalDate baseDate, Period period, HolidayCalendar calendar) {
            ArgChecker.notNull((Object)baseDate, (String)"baseDate");
            ArgChecker.notNull((Object)period, (String)"period");
            ArgChecker.notNull((Object)calendar, (String)"calendar");
            LocalDate endDate = baseDate.plus(period);
            if (calendar.isLastBusinessDayOfMonth(baseDate)) {
                return calendar.lastBusinessDayOfMonth(endDate);
            }
            return endDate;
        }

        @Override
        public boolean isMonthBased() {
            return true;
        }
    };

    private final String name;

    private StandardPeriodAdditionConventions(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

