/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.collect.ArgChecker;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;

enum StandardDateSequences implements DateSequence
{
    QUARTERLY_IMM("Quarterly-IMM"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (!base.isAfter(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (base.isBefore(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        private LocalDate shift(LocalDate base, int sequenceNumber) {
            int monthsToAdd = StandardDateSequences.monthsToAdd(base.getMonthValue(), sequenceNumber);
            return base.plusMonths(monthsToAdd).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    }
    ,
    QUARTERLY_IMM_6_SERIAL("Quarterly-IMM-6-Serial"){

        @Override
        public DateSequence baseSequence() {
            return QUARTERLY_IMM;
        }

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate baseImm = date.with(THIRD_WEDNESDAY);
            if (!baseImm.isAfter(date)) {
                baseImm = baseImm.plusMonths(1L);
            }
            return this.shift(baseImm, sequenceNumber);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate baseImm = date.with(THIRD_WEDNESDAY);
            if (baseImm.isBefore(date)) {
                baseImm = baseImm.plusMonths(1L);
            }
            return this.shift(baseImm, sequenceNumber);
        }

        private LocalDate shift(LocalDate base, int sequenceNumber) {
            if (sequenceNumber <= 6) {
                return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
            }
            int effectiveQuarterlySequenceNumber = sequenceNumber - 4;
            int monthsToAdd = StandardDateSequences.monthsToAdd(base.getMonthValue(), effectiveQuarterlySequenceNumber);
            return base.plusMonths(monthsToAdd).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    }
    ,
    QUARTERLY_IMM_3_SERIAL("Quarterly-IMM-3-Serial"){

        @Override
        public DateSequence baseSequence() {
            return QUARTERLY_IMM;
        }

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate baseImm = date.with(THIRD_WEDNESDAY);
            if (!baseImm.isAfter(date)) {
                baseImm = baseImm.plusMonths(1L);
            }
            return this.shift(baseImm, sequenceNumber);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate baseImm = date.with(THIRD_WEDNESDAY);
            if (baseImm.isBefore(date)) {
                baseImm = baseImm.plusMonths(1L);
            }
            return this.shift(baseImm, sequenceNumber);
        }

        private LocalDate shift(LocalDate base, int sequenceNumber) {
            if (sequenceNumber <= 3) {
                return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
            }
            int effectiveQuarterlySequenceNumber = sequenceNumber - 2;
            int monthsToAdd = StandardDateSequences.monthsToAdd(base.getMonthValue(), effectiveQuarterlySequenceNumber);
            return base.plusMonths(monthsToAdd).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    }
    ,
    MONTHLY_IMM("Monthly-IMM"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (!base.isAfter(date)) {
                return base.plusMonths(sequenceNumber).with(THIRD_WEDNESDAY);
            }
            return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (base.isBefore(date)) {
                return base.plusMonths(sequenceNumber).with(THIRD_WEDNESDAY);
            }
            return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return yearMonth.atDay(1).with(THIRD_WEDNESDAY);
        }
    }
    ,
    QUARTERLY_10TH("Quarterly-10th"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.withDayOfMonth(10);
            if (!base.isAfter(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.withDayOfMonth(10);
            if (base.isBefore(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        private LocalDate shift(LocalDate base, int sequenceNumber) {
            int monthsToAdd = StandardDateSequences.monthsToAdd(base.getMonthValue(), sequenceNumber);
            return base.plusMonths(monthsToAdd).withDayOfMonth(10);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    }
    ,
    MONTHLY_1ST("Monthly-1st"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.withDayOfMonth(1);
            if (!base.isAfter(date)) {
                base = base.plusMonths(1L);
            }
            return base.plusMonths(sequenceNumber - 1);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.withDayOfMonth(1);
            if (base.isBefore(date)) {
                base = base.plusMonths(1L);
            }
            return base.plusMonths(sequenceNumber - 1);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    };

    private static final TemporalAdjuster THIRD_WEDNESDAY;
    private final String name;

    private static int monthsToAdd(int baseMonth, int sequenceNumber) {
        int monthInQuarter = (baseMonth + 2) % 3;
        int monthsUntilNextQuarter = 2 - monthInQuarter;
        return monthsUntilNextQuarter + (sequenceNumber - 1) * 3;
    }

    private StandardDateSequences(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        THIRD_WEDNESDAY = TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.WEDNESDAY);
    }
}

