/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SequenceDate
implements ImmutableBean,
Serializable {
    @PropertyDefinition(get="optional")
    private final YearMonth yearMonth;
    @PropertyDefinition(get="optional")
    private final Period minimumPeriod;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final int sequenceNumber;
    @PropertyDefinition
    private final boolean fullSequence;
    private static final TypedMetaBean<SequenceDate> META_BEAN = LightMetaBean.of(SequenceDate.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"yearMonth", "minimumPeriod", "sequenceNumber", "fullSequence"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SequenceDate base(YearMonth yearMonth) {
        return new SequenceDate(yearMonth, null, 1, false);
    }

    public static SequenceDate base(YearMonth yearMonth, int sequenceNumber) {
        return new SequenceDate(yearMonth, null, sequenceNumber, false);
    }

    public static SequenceDate base(int sequenceNumber) {
        return new SequenceDate(null, null, sequenceNumber, false);
    }

    public static SequenceDate base(Period minimumPeriod, int sequenceNumber) {
        return new SequenceDate(null, minimumPeriod, sequenceNumber, false);
    }

    public static SequenceDate full(YearMonth yearMonth) {
        return new SequenceDate(yearMonth, null, 1, true);
    }

    public static SequenceDate full(YearMonth yearMonth, int sequenceNumber) {
        return new SequenceDate(yearMonth, null, sequenceNumber, true);
    }

    public static SequenceDate full(int sequenceNumber) {
        return new SequenceDate(null, null, sequenceNumber, true);
    }

    public static SequenceDate full(Period minimumPeriod, int sequenceNumber) {
        return new SequenceDate(null, minimumPeriod, sequenceNumber, true);
    }

    @ImmutableConstructor
    private SequenceDate(YearMonth yearMonth, Period minimumPeriod, int sequenceNumber, boolean fullSequence) {
        if (yearMonth != null && minimumPeriod != null) {
            throw new IllegalArgumentException("Minimum period cannot be set when year-month is present");
        }
        if (minimumPeriod != null && minimumPeriod.isNegative()) {
            throw new IllegalArgumentException("Minimum period cannot be negative");
        }
        this.yearMonth = yearMonth;
        this.minimumPeriod = Period.ZERO.equals(minimumPeriod) ? null : minimumPeriod;
        this.sequenceNumber = ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
        this.fullSequence = fullSequence;
    }

    LocalDate selectDate(LocalDate inputDate, DateSequence sequence, boolean allowSame) {
        DateSequence seq;
        DateSequence dateSequence = seq = this.fullSequence ? sequence : sequence.baseSequence();
        if (this.yearMonth != null) {
            return seq.nthOrSame(this.yearMonth.atDay(1), this.sequenceNumber);
        }
        LocalDate startDate = this.minimumPeriod != null ? inputDate.plus(this.minimumPeriod) : inputDate;
        return allowSame ? seq.nthOrSame(startDate, this.sequenceNumber) : seq.nth(startDate, this.sequenceNumber);
    }

    public static TypedMetaBean<SequenceDate> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<SequenceDate> metaBean() {
        return META_BEAN;
    }

    public Optional<YearMonth> getYearMonth() {
        return Optional.ofNullable(this.yearMonth);
    }

    public Optional<Period> getMinimumPeriod() {
        return Optional.ofNullable(this.minimumPeriod);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isFullSequence() {
        return this.fullSequence;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SequenceDate other = (SequenceDate)obj;
            return JodaBeanUtils.equal((Object)this.yearMonth, (Object)other.yearMonth) && JodaBeanUtils.equal((Object)this.minimumPeriod, (Object)other.minimumPeriod) && this.sequenceNumber == other.sequenceNumber && this.fullSequence == other.fullSequence;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yearMonth);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.minimumPeriod);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.sequenceNumber);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.fullSequence);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SequenceDate{");
        buf.append("yearMonth").append('=').append(JodaBeanUtils.toString((Object)this.yearMonth)).append(',').append(' ');
        buf.append("minimumPeriod").append('=').append(JodaBeanUtils.toString((Object)this.minimumPeriod)).append(',').append(' ');
        buf.append("sequenceNumber").append('=').append(JodaBeanUtils.toString((Object)this.sequenceNumber)).append(',').append(' ');
        buf.append("fullSequence").append('=').append(JodaBeanUtils.toString((Object)this.fullSequence));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

