/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.LocalDateUtils;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
final class NoHolidaysCalendar
implements HolidayCalendar,
ImmutableBean,
Serializable {
    static final NoHolidaysCalendar INSTANCE = new NoHolidaysCalendar();
    private static final long serialVersionUID = 1L;

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public HolidayCalendarId getId() {
        return HolidayCalendarIds.NO_HOLIDAYS;
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        return false;
    }

    @Override
    public boolean isBusinessDay(LocalDate date) {
        return true;
    }

    @Override
    public LocalDate shift(LocalDate date, int amount) {
        return LocalDateUtils.plusDays(date, amount);
    }

    @Override
    public LocalDate next(LocalDate date) {
        return LocalDateUtils.plusDays(date, 1);
    }

    @Override
    public LocalDate nextOrSame(LocalDate date) {
        return (LocalDate)ArgChecker.notNull((Object)date, (String)"date");
    }

    @Override
    public LocalDate previous(LocalDate date) {
        return LocalDateUtils.plusDays(date, -1);
    }

    @Override
    public LocalDate previousOrSame(LocalDate date) {
        return (LocalDate)ArgChecker.notNull((Object)date, (String)"date");
    }

    @Override
    public LocalDate nextSameOrLastInMonth(LocalDate date) {
        return (LocalDate)ArgChecker.notNull((Object)date, (String)"date");
    }

    @Override
    public int daysBetween(LocalDate startInclusive, LocalDate endExclusive) {
        return Math.toIntExact(LocalDateUtils.daysBetween(startInclusive, endExclusive));
    }

    @Override
    public HolidayCalendar combinedWith(HolidayCalendar other) {
        return (HolidayCalendar)ArgChecker.notNull((Object)other, (String)"other");
    }

    public boolean equals(Object obj) {
        return obj instanceof NoHolidaysCalendar;
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "HolidayCalendar[NoHolidays]";
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private NoHolidaysCalendar() {
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<NoHolidaysCalendar> {
        private Builder() {
        }

        public Object get(String propertyName) {
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public NoHolidaysCalendar build() {
            return new NoHolidaysCalendar();
        }

        public String toString() {
            return "NoHolidaysCalendar.Builder{}";
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[0]);

        private Meta() {
        }

        public BeanBuilder<? extends NoHolidaysCalendar> builder() {
            return new Builder();
        }

        public Class<? extends NoHolidaysCalendar> beanType() {
            return NoHolidaysCalendar.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }
    }
}

