/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.reflect.TypeToken;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendar;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.BufferingBeanBuilder;
import org.joda.beans.impl.StandaloneMetaProperty;
import org.joda.beans.ser.DefaultDeserializer;

final class ImmutableHolidayCalendarDeserializer
extends DefaultDeserializer {
    private static final ImmutableHolidayCalendar.Meta META_BEAN = ImmutableHolidayCalendar.meta();
    private static final MetaProperty<HolidayCalendarId> ID = META_BEAN.id();
    private static final MetaProperty<Integer> WEEKENDS = META_BEAN.weekends();
    private static final MetaProperty<Integer> START_YEAR = META_BEAN.startYear();
    private static final MetaProperty<int[]> LOOKUP = META_BEAN.lookup();
    private static final MetaProperty<Set<LocalDate>> HOLIDAYS = StandaloneMetaProperty.of((String)"holidays", (MetaBean)META_BEAN, Set.class, (Type)new TypeToken<Set<LocalDate>>(){}.getType());
    private static final MetaProperty<Set<DayOfWeek>> WEEKEND_DAYS = StandaloneMetaProperty.of((String)"weekendDays", (MetaBean)META_BEAN, Set.class, (Type)new TypeToken<Set<DayOfWeek>>(){}.getType());

    ImmutableHolidayCalendarDeserializer() {
    }

    public BeanBuilder<?> createBuilder(Class<?> beanType, MetaBean metaBean) {
        return BufferingBeanBuilder.of((MetaBean)metaBean);
    }

    public MetaProperty<?> findMetaProperty(Class<?> beanType, MetaBean metaBean, String propertyName) {
        try {
            return metaBean.metaProperty(propertyName);
        }
        catch (NoSuchElementException ex) {
            if (HOLIDAYS.name().equals(propertyName)) {
                return HOLIDAYS;
            }
            if (WEEKEND_DAYS.name().equals(propertyName)) {
                return WEEKEND_DAYS;
            }
            throw ex;
        }
    }

    public Object build(Class<?> beanType, BeanBuilder<?> builder) {
        ConcurrentMap buffer = ((BufferingBeanBuilder)builder).getBuffer();
        HolidayCalendarId id = (HolidayCalendarId)builder.get(ID);
        if (buffer.containsKey(HOLIDAYS) && buffer.containsKey(WEEKEND_DAYS)) {
            Set holidays = (Set)builder.get(HOLIDAYS);
            Set weekendDays = (Set)builder.get(WEEKEND_DAYS);
            return ImmutableHolidayCalendar.of(id, holidays, weekendDays);
        }
        int weekends = (Integer)builder.get(WEEKENDS);
        int startYear = (Integer)builder.get(START_YEAR);
        int[] lookup = (int[])builder.get(LOOKUP);
        return new ImmutableHolidayCalendar(id, weekends, startYear, lookup, false);
    }
}

